/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="getentitymeta,getplayermeta", author="BerndiVader")
public class GetEntityMetadataMap
extends SkillMechanic
implements ITargetedEntitySkill {
    boolean use_players;
    FilterEnum filter;
    UsageEnum usage;
    String data;

    public GetEntityMetadataMap(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.use_players = mlc.getLine().toLowerCase().startsWith("getplayermeta");
        this.data = mlc.getString("data", "ANY");
        this.filter = Utils.enum_lookup(FilterEnum.class, mlc.getString("filter", "NONE").toUpperCase());
        if (this.filter == null) {
            this.filter = FilterEnum.NONE;
        }
        if ((this.usage = Utils.enum_lookup(UsageEnum.class, mlc.getString("usage", "CONSOLE").toUpperCase())) == null) {
            this.usage = UsageEnum.CONSOLE;
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        Entity target = abstract_entity.getBukkitEntity();
        Map<String, Map<Plugin, MetadataValue>> map = this.filter(this.use_players ? NMSUtils.getPlayerMetadataMap(target) : NMSUtils.getEntityMetadataMap(target.getServer()), target.getUniqueId());
        for (Map.Entry<String, Map<Plugin, MetadataValue>> entry : map.entrySet()) {
            Map<Plugin, MetadataValue> values = entry.getValue();
            for (Map.Entry<Plugin, MetadataValue> values_entry : values.entrySet()) {
                String outcome = entry.getKey() + "->" + values_entry.getKey().getName() + "->" + values_entry.getValue().asString();
                switch (this.usage) {
                    case CONSOLE: {
                        System.out.println(outcome);
                        break;
                    }
                    case STANCE: {
                        if (!Utils.mobmanager.isActiveMob(data.getCaster().getEntity())) break;
                        Utils.mythicmobs.getAPIHelper().getMythicMobInstance(target).setStance(outcome);
                        break;
                    }
                }
            }
        }
        return true;
    }

    Map<String, Map<Plugin, MetadataValue>> filter(Map<String, Map<Plugin, MetadataValue>> map, UUID entity_uuid) {
        Iterator<Map.Entry<String, Map<Plugin, MetadataValue>>> map_iter = map.entrySet().iterator();
        while (map_iter.hasNext()) {
            Map.Entry<String, Map<Plugin, MetadataValue>> map_entry = map_iter.next();
            if (this.filter == FilterEnum.NONE) continue;
            if (this.filter == FilterEnum.ENTITY) {
                if (map_entry.getKey().split(":")[0].toLowerCase().equals(entity_uuid.toString())) continue;
                map_iter.remove();
                continue;
            }
            if (this.filter == FilterEnum.TAG) {
                if (map_entry.getKey().split(":")[1].toLowerCase().equals(this.data)) continue;
                map_iter.remove();
                continue;
            }
            if (this.filter != FilterEnum.PLUGIN) continue;
            Iterator<Plugin> entry_iter = map_entry.getValue().keySet().iterator();
            while (entry_iter.hasNext()) {
                String plugin_name = entry_iter.next().getName().toLowerCase();
                if (plugin_name.equals(this.data) || this.data.equals("ANY")) continue;
                entry_iter.remove();
            }
        }
        return map;
    }

    static enum UsageEnum {
        CONSOLE,
        STANCE;

    }

    static enum FilterEnum {
        NONE,
        ENTITY,
        PLUGIN,
        TAG;

    }
}

