/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.variables.Variable;
import io.lumine.xikage.mythicmobs.skills.variables.VariableMechanic;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.skills.variables.VariableType;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@ExternalAnnotation(name="getitemdata,gid", author="Seyarada")
public class GetItemData
extends VariableMechanic
implements ITargetedEntitySkill {
    private final String where;
    private final String searchKey;
    private final String get;
    private ItemStack mythicItem;
    private VariableType type;
    private int loreLine;
    private String loreRegex;
    SkillMetadata data;
    AbstractEntity target;

    public GetItemData(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.where = mlc.getString(new String[]{"where", "w"}, "HAND", new String[0]);
        this.searchKey = mlc.getString(new String[]{"key", "k"}, "Hello", new String[0]);
        this.get = mlc.getString(new String[]{"get", "g"}, "amount", new String[0]);
        this.loreLine = mlc.getInteger(new String[]{"loreline", "line"}, 0);
        this.loreRegex = mlc.getString(new String[]{"loreregex", "regex", "lr"}, null, new String[0]);
        String strType = mlc.getString(new String[]{"type", "t"}, VariableType.INTEGER.toString(), new String[0]);
        try {
            this.type = VariableType.valueOf((String)strType.toUpperCase());
        }
        catch (Exception e) {
            MythicLogger.errorMechanicConfig((SkillMechanic)this, (MythicLineConfig)mlc, (String)("'" + strType + "' is not a valid variable type."));
        }
        String baseMLC = mlc.getString(new String[]{"item", "i"}, "STONE", new String[0]);
        try {
            Material baseMaterial = Material.valueOf((String)baseMLC);
            this.mythicItem = new ItemStack(baseMaterial);
        }
        catch (Exception e) {
            ItemStack item;
            Optional t = MythicMobs.inst().getItemManager().getItem(baseMLC);
            this.mythicItem = item = BukkitAdapter.adapt((AbstractItemStack)((MythicItem)t.get()).generateItemStack(1));
        }
    }

    public boolean castAtEntity(SkillMetadata arg0, AbstractEntity arg1) {
        this.data = arg0;
        this.target = arg1;
        ItemStack iS = this.getItem();
        switch (this.get) {
            case "amount": {
                this.storeVariable(String.valueOf(iS.getAmount()));
                break;
            }
            case "count": {
                ItemStack[] items = ((Player)this.target.getBukkitEntity()).getInventory().getContents();
                int has = 0;
                for (ItemStack item : items) {
                    if (item == null || !item.isSimilar(this.mythicItem) || item.getAmount() <= 0) continue;
                    has += item.getAmount();
                }
                this.storeVariable(String.valueOf(has));
                break;
            }
            case "nbt": {
                this.storeVariable(this.readNBT(iS));
                break;
            }
            case "material": {
                this.storeVariable(String.valueOf(iS.getType()));
                break;
            }
            case "lore": {
                List loreArray;
                ItemMeta itemMeta = iS.getItemMeta();
                if (!itemMeta.hasLore() || (loreArray = itemMeta.getLore()).size() <= this.loreLine) break;
                String line = (String)loreArray.get(this.loreLine);
                if (this.loreRegex == null) {
                    this.storeVariable(line);
                    break;
                }
                Pattern pattern = Pattern.compile(this.loreRegex, 2);
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) break;
                this.storeVariable(matcher.group(0));
                break;
            }
            case "name": {
                ItemMeta itemMetaN = iS.getItemMeta();
                if (itemMetaN.hasDisplayName()) {
                    this.storeVariable(itemMetaN.getDisplayName());
                    break;
                }
                this.storeVariable(iS.getType().name());
                break;
            }
        }
        return false;
    }

    public ItemStack getItem() {
        LivingEntity entity = (LivingEntity)this.target.getBukkitEntity();
        EntityEquipment equipment = entity.getEquipment();
        switch (this.where) {
            case "HAND": {
                return equipment.getItemInMainHand().clone();
            }
            case "OFFHAND": {
                return equipment.getItemInOffHand().clone();
            }
            case "HELMET": {
                return equipment.getHelmet().clone();
            }
            case "CHESTPLATE": {
                return equipment.getChestplate().clone();
            }
            case "LEGGINGS": {
                return equipment.getLeggings().clone();
            }
            case "BOOTS": {
                return equipment.getBoots().clone();
            }
        }
        return null;
    }

    public void storeVariable(String value) {
        VariableRegistry variables = GetItemData.getVariableManager().getRegistry(this.scope, this.data, this.target);
        if (variables == null) {
            MythicLogger.errorMechanicConfig((SkillMechanic)this, (MythicLineConfig)this.config, (String)"Failed to get variable registry (MME)");
        } else {
            Variable var = null;
            if (this.type != VariableType.INTEGER && this.type != VariableType.FLOAT) {
                var = Variable.ofType((VariableType)this.type, (Object)value, (long)this.duration);
            } else if (this.type == VariableType.INTEGER) {
                if (value == "null" || value == null) {
                    value = "0";
                }
                var = Variable.ofType((VariableType)this.type, (Object)Integer.valueOf(value), (long)this.duration);
            } else if (this.type == VariableType.FLOAT) {
                if (value == "null" || value == null) {
                    value = "0";
                }
                var = Variable.ofType((VariableType)this.type, (Object)Float.valueOf(value), (long)this.duration);
            }
            variables.put(this.key, var);
        }
    }

    public String readNBT(ItemStack iS) {
        if (iS == null) {
            return "null";
        }
        CompoundTag a = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(iS);
        if (a.containsKey(this.searchKey)) {
            return a.getString(this.searchKey);
        }
        return "null";
    }
}

