/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.functions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import com.gmail.berndivader.mythicskript.MythicSkript;
import com.gmail.berndivader.mythicskript.functions.conditions.CompareEntitiesCondition;
import com.gmail.berndivader.mythicskript.functions.conditions.CompareEntityLocationCondition;
import com.gmail.berndivader.mythicskript.functions.conditions.CompareLocationsCondition;
import com.gmail.berndivader.mythicskript.functions.conditions.EntityCondition;
import com.gmail.berndivader.mythicskript.functions.conditions.LocationCondition;
import com.gmail.berndivader.mythicskript.functions.drops.ItemDrop;
import com.gmail.berndivader.mythicskript.functions.drops.MessageDrop;
import com.gmail.berndivader.mythicskript.functions.mechanics.SkriptfunctionMechanic;
import com.gmail.berndivader.mythicskript.functions.targeters.EntityTargeter;
import com.gmail.berndivader.mythicskript.functions.targeters.LocationTargeter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.targeters.ISkillTargeter;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicDropLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicTargeterLoadEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class Functions
implements Listener {
    public static void register() {
        new Functions();
    }

    public Functions() {
        MythicSkript.plugin.getServer().getPluginManager().registerEvents((Listener)this, MythicSkript.plugin);
    }

    @EventHandler
    public void onMythicMobsCustomMechanicsLoad(MythicMechanicLoadEvent e) {
        switch (e.getMechanicName().toLowerCase()) {
            case "skriptfunction": 
            case "skfunction": {
                e.register((ISkillMechanic)new SkriptfunctionMechanic(e.getContainer().getConfigLine(), e.getConfig()));
            }
        }
    }

    @EventHandler
    public void onMythicMobsCustomConditionsLoad(MythicConditionLoadEvent e) {
        switch (e.getConditionName().toLowerCase()) {
            case "skfunction": 
            case "skriptfunction": {
                MythicLineConfig mlc = e.getConfig();
                String name = mlc.getString("name", "");
                Function function = ch.njol.skript.lang.function.Functions.getGlobalFunction((String)name);
                if (function != null) {
                    if (function.getReturnType().getCodeName().equals("boolean")) {
                        Parameter[] parameters = function.getParameters();
                        int size = parameters.length;
                        if (size == 1) {
                            if (parameters[0].getType().getCodeName().equals("entity")) {
                                e.register((ISkillCondition)new EntityCondition(e.getConditionName(), e.getConfig(), function));
                                break;
                            }
                            if (parameters[0].getType().getCodeName().equals("location")) {
                                e.register((ISkillCondition)new LocationCondition(e.getConditionName(), e.getConfig(), function));
                                break;
                            }
                            Skript.warning((String)("No valid parameter found for " + name));
                            break;
                        }
                        if (size == 2) {
                            boolean para0 = parameters[0].getType().getCodeName().equals("entity");
                            boolean para1 = parameters[1].getType().getCodeName().equals("entity");
                            if (para0 && para1) {
                                e.register((ISkillCondition)new CompareEntitiesCondition(e.getConditionName(), e.getConfig(), function));
                                break;
                            }
                            if (!para0 && !para1) {
                                e.register((ISkillCondition)new CompareLocationsCondition(e.getConditionName(), e.getConfig(), function));
                                break;
                            }
                            e.register((ISkillCondition)new CompareEntityLocationCondition(e.getConditionName(), e.getConfig(), function, para0));
                            break;
                        }
                        Skript.warning((String)("There was an error with the given paramters for " + name));
                        break;
                    }
                    Skript.warning((String)("The return type for skriptcondition function " + name + " has to be boolean but is " + function.getReturnType().getCodeName()));
                    break;
                }
                Skript.warning((String)("Cant find function " + name));
            }
        }
    }

    @EventHandler
    public void onMythicMobsCustomTargeterLoad(MythicTargeterLoadEvent e) {
        switch (e.getTargeterName().toLowerCase()) {
            case "skfunction": 
            case "skriptfunction": {
                MythicLineConfig mlc = e.getConfig();
                String name = mlc.getString("name", "");
                Function function = ch.njol.skript.lang.function.Functions.getGlobalFunction((String)name);
                if (function != null) {
                    String returnType = function.getReturnType().getCodeName();
                    if (returnType.equals("location")) {
                        e.register((ISkillTargeter)new LocationTargeter(mlc, function));
                        break;
                    }
                    if (returnType.equals("entity")) {
                        e.register((ISkillTargeter)new EntityTargeter(mlc, function));
                        break;
                    }
                    Skript.warning((String)("Expected return type for skript targeter " + name + " has to be a entity or location list but is " + returnType));
                    break;
                }
                Skript.warning((String)("Cant find function " + name));
            }
        }
    }

    @EventHandler
    public void onMythicMobsDropLoad(MythicDropLoadEvent e) {
        switch (e.getDropName().toLowerCase()) {
            case "skfunction": 
            case "skriptfunction": {
                String name = e.getConfig().getString("name", "");
                Function function = ch.njol.skript.lang.function.Functions.getGlobalFunction((String)name);
                if (function != null) {
                    switch (function.getReturnType().getCodeName()) {
                        case "itemstack": {
                            e.register((IDrop)new ItemDrop(e.getContainer().getConfigLine(), e.getConfig(), function));
                            break;
                        }
                        case "string": {
                            e.register((IDrop)new MessageDrop(e.getContainer().getConfigLine(), e.getConfig(), function));
                        }
                    }
                    break;
                }
                Skript.warning((String)("Cant find function " + name));
            }
        }
    }
}

