/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.berndivader.mythicskript.Utils;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class SpawnMythicMob
extends SimpleExpression<ActiveMob> {
    private Expression<String> skriptMobtype;
    private Expression<Location> skriptLocation;
    private Expression<Object> skriptWorld;

    public boolean init(Expression<?>[] expr, int i, Kleenean var3, SkriptParser.ParseResult var4) {
        this.skriptMobtype = expr[0];
        this.skriptLocation = expr[1];
        this.skriptWorld = expr[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean var2) {
        return ((Object)((Object)this)).getClass().getSimpleName() + e != null ? "@" + e.getEventName() : "";
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ActiveMob> getReturnType() {
        return ActiveMob.class;
    }

    @Nullable
    protected ActiveMob[] get(Event e) {
        String mobtype = (String)this.skriptMobtype.getSingle(e);
        AbstractLocation location = BukkitAdapter.adapt((Location)((Location)this.skriptLocation.getSingle(e)));
        Object worldObject = this.skriptWorld.getSingle(e);
        AbstractWorld world = null;
        if (worldObject instanceof String) {
            world = BukkitAdapter.adapt((World)Bukkit.getServer().getWorld((String)this.skriptWorld.getSingle(e)));
        } else if (worldObject instanceof World) {
            world = BukkitAdapter.adapt((World)((World)this.skriptWorld.getSingle(e)));
        }
        if (location == null || world == null) {
            return null;
        }
        AbstractLocation loc = new AbstractLocation(world, location.getX(), location.getY() + 0.5, location.getZ());
        ActiveMob am = Utils.mobManager.spawnMob(mobtype, loc);
        if (am == null) {
            return null;
        }
        return new ActiveMob[]{am};
    }
}

