/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.functions.mechanics;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import com.gmail.berndivader.mythicskript.Utils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillMechanic;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class SkriptfunctionMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill,
ITargetedLocationSkill {
    Function<?> function;
    Object[][] parameters;
    int dataPos;
    int locationPos;
    int entityPos;
    String name;

    public SkriptfunctionMechanic(String skill, MythicLineConfig mlc) {
        super(Utils.mythicMobs.getSkillManager(), skill, mlc);
        this.name = mlc.getString("name", "");
        this.function = Functions.getGlobalFunction((String)this.name);
        if (this.function != null) {
            this.parameters = new Object[this.function.getParameters().length][];
            this.entityPos = -1;
            this.locationPos = -1;
            this.dataPos = -1;
            block10: for (int i = 0; i < this.function.getParameters().length; ++i) {
                String type;
                switch (type = this.function.getParameter(i).getType().getCodeName()) {
                    case "skilldata": {
                        this.dataPos = i;
                        continue block10;
                    }
                    case "location": {
                        this.locationPos = i;
                        continue block10;
                    }
                    case "entity": {
                        this.entityPos = i;
                    }
                }
            }
        } else {
            Skript.warning((String)("Cant find function " + this.name));
        }
    }

    public SkillResult castAtLocation(SkillMetadata meta, AbstractLocation aLocation) {
        if (this.dataPos > -1) {
            this.parameters[this.dataPos] = new SkillMetadata[]{meta};
        }
        if (this.locationPos > -1) {
            this.parameters[this.locationPos] = new Location[]{BukkitAdapter.adapt((AbstractLocation)aLocation)};
        }
        if (this.entityPos > -1) {
            this.parameters[this.entityPos] = new Entity[0];
        }
        this.function.execute(this.parameters);
        return SkillResult.SUCCESS;
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity aEntity) {
        if (this.dataPos > -1) {
            this.parameters[this.dataPos] = new SkillMetadata[]{meta};
        }
        if (this.locationPos > -1) {
            this.parameters[this.locationPos] = new Location[0];
        }
        if (this.entityPos > -1) {
            this.parameters[this.entityPos] = new Entity[]{aEntity.getBukkitEntity()};
        }
        this.function.execute(this.parameters);
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata meta) {
        if (this.dataPos > -1) {
            this.parameters[this.dataPos] = new SkillMetadata[]{meta};
        }
        if (this.locationPos > -1) {
            this.parameters[this.locationPos] = new Location[0];
        }
        if (this.entityPos > -1) {
            this.parameters[this.entityPos] = new Entity[0];
        }
        this.function.execute(this.parameters);
        return SkillResult.SUCCESS;
    }
}

