/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.berndivader.mythicskript.Utils;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ConvertToMythicMob
extends SimpleExpression<ActiveMob> {
    private Expression<String> skMobtype;
    private Expression<Entity> skEntity;
    private Expression<Number> skLevel;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ActiveMob> getReturnType() {
        return ActiveMob.class;
    }

    public boolean init(Expression<?>[] expr, int pattern, Kleenean var3, SkriptParser.ParseResult var4) {
        this.skEntity = expr[0];
        this.skMobtype = expr[1];
        this.skLevel = expr[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean bool) {
        return ((Object)((Object)this)).getClass().getSimpleName() + e != null ? "@" + e.getEventName() : "";
    }

    @Nullable
    protected ActiveMob[] get(Event e) {
        Entity entity = (Entity)this.skEntity.getSingle(e);
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity le = (LivingEntity)entity;
        if (le instanceof Player) {
            return null;
        }
        String type = (String)this.skMobtype.getSingle(e);
        int level = ((Number)this.skLevel.getSingle(e)).intValue();
        Optional maybe = Utils.mobManager.getMythicMob(type);
        if (!maybe.isPresent()) {
            return null;
        }
        MythicMob mm = (MythicMob)maybe.get();
        ActiveMob am = new ActiveMob(BukkitAdapter.adapt((Entity)le), mm, (double)level);
        if (am != null) {
            ConvertToMythicMob.addActiveMobToFaction(mm, am);
            ConvertToMythicMob.registerActiveMob(am);
        }
        return new ActiveMob[]{am};
    }

    private static void addActiveMobToFaction(MythicMob mm, ActiveMob am) {
        if (mm.hasFaction()) {
            am.setFaction(mm.getFaction());
            am.getEntity().setMetadata("Faction", (Object)new FixedMetadataValue((Plugin)Utils.mythicMobs, (Object)mm.getFaction()));
        }
    }

    private static void registerActiveMob(ActiveMob am) {
        Utils.mobManager.registerActiveMob(am);
    }
}

