/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicskript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.berndivader.mythicskript.ActivePlayer;
import com.gmail.berndivader.mythicskript.MythicSkript;
import com.gmail.berndivader.mythicskript.Utils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class MakePlayerCastSkill
extends Effect {
    private Expression<Entity> skriptPlayer;
    private Expression<Entity> skriptTrigger;
    private Expression<String> skriptSkill;
    private Expression<Entity> skriptTarget;
    private Expression<Location> skriptLocation;
    private boolean bool;
    private boolean self;
    private Expression<Number> skriptDelay;
    private Expression<Number> skriptTimer;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean var3, SkriptParser.ParseResult var4) {
        this.bool = matchedPattern == 0;
        this.self = matchedPattern == 2;
        this.skriptPlayer = expr[0];
        this.skriptSkill = expr[1];
        this.skriptTrigger = expr[2];
        if (this.self) {
            this.skriptDelay = expr[3];
            this.skriptTimer = expr[4];
            return true;
        }
        this.skriptDelay = expr[4];
        this.skriptTimer = expr[5];
        if (this.bool) {
            this.skriptTarget = expr[3];
        } else {
            this.skriptLocation = expr[3];
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean var2) {
        return ((Object)((Object)this)).getClass().getSimpleName() + e != null ? "@" + e.getEventName() : "";
    }

    protected void execute(Event e) {
        Entity caster = (Entity)this.skriptPlayer.getSingle(e);
        Entity trigger = (Entity)this.skriptTrigger.getSingle(e);
        Entity etarget = null;
        int ttimer = ((Number)this.skriptTimer.getSingle(e)).intValue();
        long tdelay = ((Number)this.skriptDelay.getSingle(e)).longValue();
        Location ltarget = null;
        if (this.bool) {
            etarget = (Entity)this.skriptTarget.getSingle(e);
        } else if (!this.self) {
            ltarget = (Location)this.skriptLocation.getSingle(e);
        }
        if (this.self) {
            etarget = caster;
        }
        String skill = (String)this.skriptSkill.getSingle(e);
        HashSet<AbstractEntity> eTargets = new HashSet<AbstractEntity>();
        HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
        if (etarget != null) {
            eTargets.add(BukkitAdapter.adapt((Entity)etarget));
        }
        if (ltarget != null) {
            lTargets.add(BukkitAdapter.adapt((Location)ltarget));
        }
        if (!MakePlayerCastSkill.castSkillFromPlayer(caster, skill, trigger, caster.getLocation(), eTargets, lTargets, 1.0f, ttimer, tdelay)) {
            Skript.warning((String)("MythicMobs skill " + skill + " not found!"));
        }
    }

    private static boolean castSkillFromPlayer(Entity e, String skillName, Entity trigger, Location origin, HashSet<AbstractEntity> feTargets, HashSet<AbstractLocation> flTargets, float power, final int ttimer, long tdelay) {
        SkillMetadataImpl data;
        Optional maybeSkill = Utils.mythicMobs.getSkillManager().getSkill(skillName);
        if (!maybeSkill.isPresent()) {
            return false;
        }
        ActivePlayer ap = new ActivePlayer(e);
        final Skill skill = (Skill)maybeSkill.get();
        if (skill.isUsable((SkillMetadata)(data = new SkillMetadataImpl(SkillTriggers.API, (SkillCaster)ap, BukkitAdapter.adapt((Entity)trigger), BukkitAdapter.adapt((Location)origin), feTargets, flTargets, power)), SkillTriggers.API)) {
            new BukkitRunnable(){
                int timer;
                {
                    this.timer = ttimer;
                }

                public void run() {
                    if (this.timer != -1) {
                        skill.execute((SkillMetadata)data);
                        --this.timer;
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer(MythicSkript.plugin, 0L, tdelay);
        }
        return true;
    }
}

