/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackLoader;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BaseAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OggAudioTrack
extends BaseAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(OggAudioTrack.class);
    private final SeekableInputStream inputStream;

    public OggAudioTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        super(trackInfo);
        this.inputStream = inputStream;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws IOException {
        OggPacketInputStream packetInputStream = new OggPacketInputStream(this.inputStream, false);
        OggTrackBlueprint blueprint = OggTrackLoader.loadTrackBlueprint(packetInputStream);
        log.debug("Starting to play an OGG track {}", (Object)this.getIdentifier());
        if (blueprint == null) {
            throw new IOException("Stream terminated before the first packet.");
        }
        OggTrackHandler handler = blueprint.loadTrackHandler(packetInputStream);
        localExecutor.executeProcessingLoop(() -> {
            try {
                this.processTrackLoop(packetInputStream, localExecutor.getProcessingContext(), handler, blueprint);
            }
            catch (IOException e) {
                throw new FriendlyException("Stream broke when playing OGG track.", FriendlyException.Severity.SUSPICIOUS, e);
            }
        }, handler::seekToTimecode, true);
    }

    private void processTrackLoop(OggPacketInputStream packetInputStream, AudioProcessingContext context, OggTrackHandler handler, OggTrackBlueprint blueprint) throws IOException, InterruptedException {
        while (blueprint != null) {
            handler.initialise(context, 0L, 0L);
            handler.provideFrames();
            blueprint = OggTrackLoader.loadTrackBlueprint(packetInputStream);
        }
    }
}

