/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.extensions.youtuberotator.planner;

import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.tools.BigRandom;
import com.sedmelluq.lava.extensions.youtuberotator.tools.Tuple;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv6Block;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NanoIpRoutePlanner
extends AbstractRoutePlanner {
    private static final Logger log = LoggerFactory.getLogger(NanoIpRoutePlanner.class);
    private static final BigRandom random = new BigRandom();
    private final BigInteger startTime;
    private final int maskBits;

    public NanoIpRoutePlanner(List<IpBlock> ipBlocks, boolean handleSearchFailure) {
        super(ipBlocks, handleSearchFailure);
        if (this.ipBlock.getSize().compareTo(Ipv6Block.BLOCK64_IPS) < 0) {
            throw new IllegalArgumentException("Nano IP Route planner requires an IPv6Block which is greater or equal to a /64");
        }
        this.startTime = BigInteger.valueOf(System.nanoTime());
        this.maskBits = this.ipBlock.getMaskBits();
    }

    public long getCurrentAddress() {
        return System.nanoTime() - this.startTime.longValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Tuple<InetAddress, InetAddress> determineAddressPair(Tuple<Inet4Address, Inet6Address> remoteAddresses) throws HttpException {
        InetAddress remoteAddress;
        InetAddress currentAddress = null;
        if (this.ipBlock.getType() == Inet4Address.class) {
            if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
            currentAddress = this.getAddress();
            remoteAddress = (InetAddress)remoteAddresses.l;
        } else {
            if (this.ipBlock.getType() != Inet6Address.class) throw new HttpException("Unknown IpBlock type: " + this.ipBlock.getType().getCanonicalName());
            if (remoteAddresses.r != null) {
                currentAddress = this.getAddress();
                remoteAddress = (InetAddress)remoteAddresses.r;
            } else {
                if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
                remoteAddress = (InetAddress)remoteAddresses.l;
                log.warn("Could not look up AAAA record for host. Falling back to unbalanced IPv4.");
            }
        }
        if (currentAddress == null) return new Tuple<InetAddress, InetAddress>(currentAddress, remoteAddress);
        log.debug("Selected {} as new outgoing IP", (Object)currentAddress);
        return new Tuple<InetAddress, InetAddress>(currentAddress, remoteAddress);
    }

    private InetAddress getAddress() {
        BigInteger now = BigInteger.valueOf(System.nanoTime());
        BigInteger nanoOffset = now.subtract(this.startTime);
        if (this.maskBits == 64) {
            return this.ipBlock.getAddressAtIndex(nanoOffset);
        }
        BigInteger randomOffset = random.nextBigInt(128 - this.maskBits).shiftLeft(128 - this.maskBits);
        return this.ipBlock.getAddressAtIndex(randomOffset.add(nanoOffset));
    }
}

