/*
 * Decompiled with CFR 0.152.
 */
package ibxm;

import ibxm.Note;

public class Pattern {
    public int numRows;
    public byte[] data;

    public Pattern(int numChannels, int numRows) {
        this.numRows = numRows;
        this.data = new byte[numChannels * numRows * 5];
    }

    public Note getNote(int index, Note note) {
        int offset = index * 5;
        note.key = this.data[offset] & 0xFF;
        note.instrument = this.data[offset + 1] & 0xFF;
        note.volume = this.data[offset + 2] & 0xFF;
        note.effect = this.data[offset + 3] & 0xFF;
        note.param = this.data[offset + 4] & 0xFF;
        return note;
    }

    public void toStringBuffer(StringBuffer out) {
        Note note = new Note();
        char[] chars = new char[10];
        int numChannels = this.data.length / (this.numRows * 5);
        for (int row = 0; row < this.numRows; ++row) {
            for (int channel = 0; channel < numChannels; ++channel) {
                this.getNote(numChannels * row + channel, note);
                note.toChars(chars);
                out.append(chars);
                out.append(' ');
            }
            out.append('\n');
        }
    }

    public String toString() {
        int numChannels = this.data.length / (this.numRows * 5);
        StringBuffer stringBuffer = new StringBuffer(this.numRows * numChannels * 11 + this.numRows);
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }
}

