/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.ffmpeg;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.FFmpeg;
import com.github.kokorin.jaffree.ffmpeg.FFmpegProgress;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResult;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResultFuture;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.OutputListener;
import com.github.kokorin.jaffree.ffmpeg.ProgressListener;
import com.github.kokorin.jaffree.ffmpeg.UrlInput;
import com.github.kokorin.jaffree.ffmpeg.UrlOutput;
import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.mysql.GetNextScheduled;
import com.gmail.berndivader.streamserver.mysql.UpdateCurrent;
import com.gmail.berndivader.streamserver.mysql.UpdatePlaylist;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.Broadcast;
import com.gmail.berndivader.streamserver.youtube.BroadcastStatus;
import com.gmail.berndivader.streamserver.youtube.PrivacyStatus;
import com.gmail.berndivader.streamserver.youtube.packets.EmptyPacket;
import com.gmail.berndivader.streamserver.youtube.packets.ErrorPacket;
import com.gmail.berndivader.streamserver.youtube.packets.LiveBroadcastPacket;
import com.gmail.berndivader.streamserver.youtube.packets.LiveStreamPacket;
import com.gmail.berndivader.streamserver.youtube.packets.Packet;
import com.gmail.berndivader.streamserver.youtube.packets.UnknownPacket;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public final class BroadcastRunner
extends TimerTask {
    private static AtomicBoolean stop;
    public static AtomicBoolean hold;
    private static volatile FFmpegProgress progress;
    private static volatile FFProbePacket playingPacket;
    private static volatile String message;
    private static volatile File playing;
    private static FFmpegResultFuture ffmpeg;
    public static AtomicInteger index;
    public static Packet liveBroadcast;
    public static Packet liveStream;
    private static long expiredCounter;
    private static volatile CopyOnWriteArrayList<File> files;
    private static volatile CopyOnWriteArrayList<File> customs;
    public static BroadcastRunner instance;
    private long period = 2L;

    public static synchronized FFmpegProgress progress() {
        return progress;
    }

    public static synchronized void progress(FFmpegProgress progress) {
        BroadcastRunner.progress = progress;
    }

    public static synchronized FFProbePacket playingPacket() {
        return playingPacket;
    }

    public static synchronized void playingPacket(FFProbePacket packet) {
        playingPacket = packet;
    }

    public static synchronized String message() {
        return message;
    }

    public static synchronized void message(String message) {
        BroadcastRunner.message = message;
    }

    public static synchronized File playing() {
        return playing;
    }

    public static synchronized void playing(File playing) {
        BroadcastRunner.playing = playing;
    }

    public static synchronized FFmpegResultFuture ffmpeg() {
        return ffmpeg;
    }

    public static synchronized void ffmpeg(FFmpegResultFuture ffmpeg) {
        BroadcastRunner.ffmpeg = ffmpeg;
    }

    public BroadcastRunner() {
        ANSI.print("[YELLOW]Starting BroadcastRunner...");
        stop.set(false);
        hold.set(false);
        BroadcastRunner.refreshFilelist();
        BroadcastRunner.shuffleFilelist();
        BroadcastRunner.checkOrReInitiateLiveBroadcast(Config.BROADCAST_DEFAULT_TITLE, Config.BROADCAST_DEFAULT_DESCRIPTION, Config.broadcastPrivacyStatus());
        index.set(0);
        expiredCounter = 0L;
        BroadcastRunner.startStream();
        Helper.SCHEDULED_EXECUTOR.scheduleAtFixedRate(this, 0L, this.period, TimeUnit.SECONDS);
        ANSI.println("[GREEN]DONE![RESET]");
    }

    public void stop() throws InterruptedException {
        ANSI.print("[YELLOW]Stopping BroadcastRunner...");
        stop.set(true);
        if (!(BroadcastRunner.ffmpeg() == null || BroadcastRunner.ffmpeg().isCancelled() && BroadcastRunner.ffmpeg().isDone())) {
            ANSI.print("[YELLOW][Stop broadcasting...");
            FFmpegResult result = BroadcastRunner.stopStream();
            if (result != null) {
                ANSI.print("[GREEN]DONE!]...[RESET]");
            } else {
                ANSI.warn("Problem occured while stopping the BroadcastRunner.");
            }
        }
        ANSI.println("[GREEN]DONE![RESET]");
    }

    @Override
    public void run() {
        long refreshTimer = 0L;
        if (!stop.get()) {
            refreshTimer += this.period;
            expiredCounter += this.period;
            if (!hold.get()) {
                if (BroadcastRunner.ffmpeg() == null || BroadcastRunner.ffmpeg().isCancelled() || BroadcastRunner.ffmpeg().isDone()) {
                    BroadcastRunner.startStream();
                }
                if (expiredCounter > Config.YOUTUBE_TOKEN_EXPIRE_TIME) {
                    BroadcastRunner.checkOrReInitiateLiveBroadcast(Config.BROADCAST_DEFAULT_TITLE, Config.BROADCAST_DEFAULT_DESCRIPTION, Config.broadcastPrivacyStatus());
                    expiredCounter = 0L;
                }
            } else if (refreshTimer > 60L) {
                BroadcastRunner.refreshFilelist();
                BroadcastRunner.shuffleFilelist();
                try {
                    new UpdatePlaylist(false);
                    hold.set(files.size() > 0);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    ANSI.error("Failed to update playlist.", e);
                }
            }
        }
    }

    public static synchronized void checkOrReInitiateLiveBroadcast(String title, String description, PrivacyStatus privacy) {
        if (Config.DEBUG.booleanValue()) {
            ANSI.info("[BLUE]Test if broadcast is still live on Youtube...[RESET]");
        }
        try {
            Packet packet = liveBroadcast = Broadcast.getLiveBroadcastWithTries(BroadcastStatus.active, 2);
            if (packet instanceof EmptyPacket) {
                ANSI.println("[YELLOW]Try to reinstall livebroadcast on Youtube...");
                packet = liveStream = Broadcast.getDefaultLiveStream().get(15L, TimeUnit.SECONDS);
                if (packet instanceof LiveStreamPacket) {
                    ANSI.println("[GREEN]Got livestream resource identified by STREAM_KEY...");
                    LiveStreamPacket live = (LiveStreamPacket)packet;
                    packet = Broadcast.insertLiveBroadcast(title, description, privacy).get(15L, TimeUnit.SECONDS);
                    if (packet instanceof LiveBroadcastPacket) {
                        ANSI.println("[GREEN]Installed a new autostart livebroadcast resource on Youtube...");
                        LiveBroadcastPacket broadcast = (LiveBroadcastPacket)packet;
                        packet = Broadcast.bindBroadcastToStream(broadcast.id, live.id).get(15L, TimeUnit.SECONDS);
                        if (packet instanceof LiveBroadcastPacket) {
                            ANSI.println("[GREEN]Merged the default livestream with the new livebroadcast together...");
                            broadcast = (LiveBroadcastPacket)packet;
                            if (Config.DEBUG.booleanValue()) {
                                ANSI.info(broadcast.source().toString());
                            }
                            ANSI.println("[BLUE]The new livestream should go live in a few seconds.[PROMPT]");
                        }
                    }
                }
                if (packet instanceof ErrorPacket) {
                    ANSI.println("[RED]FAILED!");
                    ErrorPacket error = (ErrorPacket)packet;
                    error.printSimple();
                } else if (packet instanceof EmptyPacket) {
                    ANSI.println("[RED]FAILED!");
                    ANSI.warn("Received EmptyPacket!");
                    if (Config.DEBUG.booleanValue()) {
                        ANSI.info(packet.source().toString());
                    }
                } else if (packet instanceof UnknownPacket) {
                    ANSI.println("[RED]FAILED!");
                    ANSI.warn("Unknown packet received!");
                    if (Config.DEBUG.booleanValue()) {
                        ANSI.info(packet.source().toString());
                    }
                }
            } else if (packet instanceof ErrorPacket) {
                ErrorPacket error = (ErrorPacket)packet;
                error.printSimple();
            } else if (packet instanceof LiveBroadcastPacket) {
                LiveBroadcastPacket broadcast = (LiveBroadcastPacket)packet;
                ANSI.println("Broadcast is live on Youtube.");
                if (Config.DEBUG.booleanValue()) {
                    ANSI.info(broadcast.source().toString());
                }
            }
        }
        catch (Exception e) {
            ANSI.error("Failed to restart live broadcast on Youtube.", e);
        }
    }

    private static synchronized void startStream() {
        GetNextScheduled scheduled = new GetNextScheduled();
        try {
            String name = scheduled.future.get(20L, TimeUnit.SECONDS);
            if (name != null) {
                BroadcastRunner.getFileByName(name.toLowerCase()).ifPresent(BroadcastRunner::createStream);
                return;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.error("Get next scheduled file failed.", e);
        }
        File[] files = BroadcastRunner.getFiles();
        if (files.length > 0) {
            BroadcastRunner.createStream(BroadcastRunner.getFiles()[index.get()]);
            index.set((index.get() + 1) % BroadcastRunner.getFiles().length);
        } else {
            ANSI.info("Broadcasting is on hold because there are no mediafiles inside playlist dirctory.");
            hold.set(true);
        }
    }

    private static synchronized void createStream(File file) {
        int pos;
        BroadcastRunner.playingPacket(FFProbePacket.build(file));
        String title = "";
        title = BroadcastRunner.playingPacket().isSet(BroadcastRunner.playingPacket().tags.title) ? BroadcastRunner.playingPacket().tags.title : ((pos = file.getName().lastIndexOf(".")) > 0 ? file.getName().substring(0, pos) : file.getName());
        new UpdateCurrent(title, BroadcastRunner.playingPacket().toString());
        if (Config.DISCORD_BOT_START.booleanValue() && DiscordBot.instance != null) {
            DiscordBot.instance.updateStatus(title);
        }
        if (Config.DEBUG.booleanValue()) {
            ANSI.info("[BLUE]Now playing: " + BroadcastRunner.playingPacket().tags.title + ":" + BroadcastRunner.playingPacket().tags.artist + ":" + BroadcastRunner.playingPacket().tags.date + ":" + BroadcastRunner.playingPacket().tags.comment + "[RESET]");
            ANSI.prompt();
        }
        Path path = Paths.get(Config.DL_FFMPEG_PATH, new String[0]);
        BroadcastRunner.ffmpeg(FFmpeg.atPath(path.getParent()).addInput((Input)UrlInput.fromUrl(file.getAbsolutePath()).addArgument("-re")).addOutput((Output)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)UrlOutput.toUrl(Config.YOUTUBE_STREAM_URL + "/" + Config.YOUTUBE_STREAM_KEY).setCodec(StreamType.VIDEO, "copy")).setCodec(StreamType.AUDIO, "copy")).addArguments("-strict", "-2")).addArguments("-flags", "+global_header")).addArguments("-bsf:a", "aac_adtstoasc")).addArguments("-bufsize", "2100k")).setFormat("flv")).setOutputListener(new OutputListener(){

            @Override
            public void onOutput(String message) {
                BroadcastRunner.message(message);
            }
        }).setProgressListener(new ProgressListener(){

            @Override
            public void onProgress(FFmpegProgress progress) {
                BroadcastRunner.progress(progress);
            }
        }).setOverwriteOutput(true).executeAsync());
        if (BroadcastRunner.ffmpeg() != null && !BroadcastRunner.ffmpeg().isDone() && !BroadcastRunner.ffmpeg().isCancelled()) {
            BroadcastRunner.playing(file);
        }
    }

    public static boolean isStreaming() {
        return BroadcastRunner.ffmpeg() != null && !BroadcastRunner.ffmpeg().isCancelled() && !BroadcastRunner.ffmpeg().isDone();
    }

    public static void playFile(File file) {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
            BroadcastRunner.createStream(file);
        }
    }

    public static void playPosition(int idx) {
        index.set(idx);
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
    }

    public static void restart() {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
        BroadcastRunner.createStream(BroadcastRunner.playing());
    }

    public static void next() {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
    }

    public static void previous() {
        if (BroadcastRunner.isStreaming()) {
            index.set((index.get() - 2 + BroadcastRunner.getFiles().length) % BroadcastRunner.getFiles().length);
            BroadcastRunner.stopStream();
        }
    }

    private static FFmpegResult stopStream() {
        if (BroadcastRunner.ffmpeg() != null && !BroadcastRunner.ffmpeg().isCancelled() && !BroadcastRunner.ffmpeg().isDone()) {
            BroadcastRunner.ffmpeg().graceStop();
            try {
                return BroadcastRunner.ffmpeg().get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ANSI.error("Failed to stop broadcast task.", e);
            }
        }
        return null;
    }

    public static File[] getFiles() {
        return (File[])files.toArray(File[]::new);
    }

    public static Optional<File> getFileByName(String name) {
        File file = null;
        int pos = BroadcastRunner.getFilePosition(name);
        if (pos != -1 && (file = files.get(pos)).exists() && file.isFile() && file.canRead()) {
            return Optional.of(file);
        }
        pos = BroadcastRunner.getCustomFilePosition(name);
        if (pos != -1 && (file = customs.get(pos)).exists() && file.isFile() && file.canRead()) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private static int getFilePosition(String name) {
        if (!name.isEmpty()) {
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                if (!files.get(i).getName().equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    private static int getCustomFilePosition(String name) {
        if (!name.isEmpty()) {
            int size = customs.size();
            for (int i = 0; i < size; ++i) {
                if (!customs.get(i).getName().equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<String> getFilesAsList(String r) {
        String regex = r.contains("*") ? r.replaceAll("\\*", "(.*)") : "(.*)" + r + "(.*)";
        ArrayList<String> list = new ArrayList<String>();
        Stream.concat(files.stream(), customs.stream()).map(File::getName).filter(name -> {
            try {
                return name.toLowerCase().matches(regex);
            }
            catch (Exception e) {
                if (Config.DEBUG.booleanValue()) {
                    ANSI.error("getFilelistAsList method failed.", e);
                }
                return false;
            }
        }).forEach(list::add);
        return list;
    }

    public static String getFilesAsString(String r) {
        AtomicInteger count = new AtomicInteger(0);
        StringBuilder playlist = new StringBuilder();
        String regex = r.contains("*") ? r.replaceAll("\\*", "(.*)") : "(.*)" + r + "(.*)";
        Stream.concat(files.stream(), customs.stream()).map(File::getName).filter(name -> {
            try {
                return name.toLowerCase().matches(regex);
            }
            catch (Exception e) {
                if (Config.DEBUG.booleanValue()) {
                    ANSI.error("getFilelistAsString method failed.", e);
                }
                return false;
            }
        }).forEach(name -> {
            playlist.append(name + "\n");
            count.incrementAndGet();
        });
        playlist.append("\nThere are ").append(count).append(" matches for ").append(regex);
        return playlist.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffleFilelist() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        CopyOnWriteArrayList<File> copyOnWriteArrayList = files;
        synchronized (copyOnWriteArrayList) {
            int size = files.size();
            for (int i1 = size - 1; i1 > 0; --i1) {
                int index = ((Random)random).nextInt(i1 + 1);
                File a = files.get(index);
                files.set(index, files.get(i1));
                files.set(i1, a);
            }
        }
    }

    private static File[] getFiles(File directory, FileFilter filter) {
        if (directory.exists()) {
            if (directory.isDirectory()) {
                return directory.listFiles(filter);
            }
            if (directory.isFile()) {
                return new File[]{directory};
            }
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshFilelist() {
        File playlistDir = new File(Config.working_dir, Config.PLAYLIST_PATH);
        File customDir = new File(Config.working_dir, Config.PLAYLIST_PATH_CUSTOM);
        FileFilter filter = pathName -> pathName.getAbsolutePath().toLowerCase().endsWith(".mp4");
        List<File> newFiles = Arrays.asList(BroadcastRunner.getFiles(playlistDir, filter));
        CopyOnWriteArrayList<File> copyOnWriteArrayList = files;
        synchronized (copyOnWriteArrayList) {
            files.clear();
            files.addAll(newFiles);
        }
        newFiles = Arrays.asList(BroadcastRunner.getFiles(customDir, filter));
        copyOnWriteArrayList = customs;
        synchronized (copyOnWriteArrayList) {
            customs.clear();
            customs.addAll(newFiles);
        }
    }

    static {
        index = new AtomicInteger();
        liveBroadcast = Packet.emtpy();
        liveStream = Packet.emtpy();
        files = new CopyOnWriteArrayList();
        customs = new CopyOnWriteArrayList();
        stop = new AtomicBoolean();
        hold = new AtomicBoolean();
    }
}

