/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.ffmpeg;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.stream.Stream;

public class FFProbePacket {
    private static final String UNKNOWN = "<UNKNOWN>";
    private String filename = "<UNKNOWN>";
    private String file = "<UNKNOWN>";
    public Integer nb_streams = -1;
    public Integer nb_programs = -1;
    public Integer nb_stream_groups = -1;
    public String format_name = "<UNKNOWN>";
    public String format_long_name = "<UNKNOWN>";
    public String start_time = "0";
    public String duration = "0";
    public String size = "0";
    public String bit_rate = "<UNKNOWN>";
    public Integer probe_score = -1;
    public Tags tags = new Tags(this);

    private FFProbePacket() {
    }

    public String getFileName() {
        return this.file;
    }

    public String getPath() {
        return this.filename;
    }

    public String toString() {
        return Helper.LGSON.toJson(this);
    }

    public boolean isSet(String field) {
        return field != null && !field.equals(UNKNOWN) && !field.isEmpty();
    }

    public static FFProbePacket build(File file) {
        FFProbePacket packet = new FFProbePacket();
        if (file != null && file.exists()) {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            String path = file.getAbsolutePath();
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                ANSI.error(e.getMessage(), e);
            }
            builder.command(Config.DL_FFPROBE_PATH, "-v", "quiet", "-print_format", "json", "-show_format", path);
            try {
                JsonObject o;
                AbstractMap.SimpleEntry<String, String> output = Helper.startAndWaitForProcess(builder, 10L);
                String out = output.getKey();
                String err = output.getValue();
                if (!err.isEmpty()) {
                    ANSI.error(err, null);
                }
                if (!out.isEmpty() && (o = JsonParser.parseString(out).getAsJsonObject()).has("format")) {
                    Tags tags = packet.tags;
                    packet = Helper.LGSON.fromJson(o.get("format"), FFProbePacket.class);
                    packet.tags = FFProbePacket.mergeTags(tags, packet.tags);
                }
            }
            catch (Exception e) {
                ANSI.error("getProbePacket method failed.", e);
            }
            packet.file = file.getName();
            if (!packet.isSet(packet.tags.title)) {
                int lastDot = packet.file.lastIndexOf(46);
                packet.tags.title = lastDot != -1 ? packet.file.substring(0, lastDot) : packet.file;
            }
        }
        return packet;
    }

    private static Tags mergeTags(Tags def, Tags parsed) {
        if (parsed == null) {
            return def;
        }
        Field[] fields = Tags.class.getDeclaredFields();
        Stream.of(fields).forEach(field -> {
            block3: {
                try {
                    Object value = field.get(parsed);
                    if (value != null) {
                        field.set(def, value);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    if (!Config.DEBUG.booleanValue()) break block3;
                    ANSI.error(e.getMessage(), e);
                }
            }
        });
        return def;
    }

    public class Tags {
        @SerializedName(value="title", alternate={"TITLE"})
        public String title = "<UNKNOWN>";
        @SerializedName(value="artist", alternate={"ARTIST"})
        public String artist = "<UNKNOWN>";
        @SerializedName(value="major_brand", alternate={"MAJOR_BRAND"})
        public String major_brand = "<UNKNOWN>";
        @SerializedName(value="minor_version", alternate={"MINOR_VERSION"})
        public String minor_version = "<UNKNOWN>";
        @SerializedName(value="compatible_brands", alternate={"COMPATIBLE_BRANDS"})
        public String compatible_brands = "<UNKNOWN>";
        @SerializedName(value="date", alternate={"DATE"})
        public String date = "0";
        @SerializedName(value="encoder", alternate={"ENCODER"})
        public String encoder = "<UNKNOWN>";
        @SerializedName(value="comment", alternate={"COMMENT"})
        public String comment = "<UNKNOWN>";
        @SerializedName(value="description", alternate={"DESCRIPTION"})
        public String description = "<UNKNOWN>";
        @SerializedName(value="synopsis", alternate={"SYNOPSIS"})
        public String synopsis = "<UNKNOWN>";
        @SerializedName(value="purl", alternate={"PURL"})
        public String purl = "";

        public Tags(FFProbePacket this$0) {
        }
    }
}

