/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.BaseYoutubeHttpContextFilter;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchResultLoader;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeSearchProvider
implements YoutubeSearchResultLoader {
    private static final Logger log = LoggerFactory.getLogger(YoutubeSearchProvider.class);
    private static final String WATCH_URL_PREFIX = "https://www.youtube.com/watch?v=";
    private final HttpInterfaceManager httpInterfaceManager;
    private final Pattern polymerInitialDataRegex = Pattern.compile("(window\\[\"ytInitialData\"]|var ytInitialData)\\s*=\\s*(.*);");

    public YoutubeSearchProvider() {
        this.httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();
        this.httpInterfaceManager.setHttpContextFilter(new BaseYoutubeHttpContextFilter());
    }

    @Override
    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    /*
     * Exception decompiling
     */
    @Override
    public AudioItem loadSearchResult(String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AudioItem extractSearchResults(Document document, String query, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        ArrayList<AudioTrack> tracks = new ArrayList();
        Elements resultsSelection = document.select("#page > #content #results");
        if (!resultsSelection.isEmpty()) {
            for (Element results : resultsSelection) {
                for (Element result : results.select(".yt-lockup-video")) {
                    if (result.hasAttr("data-ad-impressions") || !result.select(".standalone-ypc-badge-renderer-label").isEmpty()) continue;
                    this.extractTrackFromResultEntry(tracks, result, trackFactory);
                }
            }
        } else {
            log.debug("Attempting to parse results page as polymer");
            try {
                tracks = this.polymerExtractTracks(document, trackFactory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search results for: " + query, tracks, null, true);
    }

    private void extractTrackFromResultEntry(List<AudioTrack> tracks, Element element, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        Element durationElement = element.select("[class^=video-time]").first();
        Element contentElement = element.select(".yt-lockup-content").first();
        String videoId = element.attr("data-context-item-id");
        if (durationElement == null || contentElement == null || videoId.isEmpty()) {
            return;
        }
        long duration = DataFormatTools.durationTextToMillis(durationElement.text());
        String title = contentElement.select(".yt-lockup-title > a").text();
        String author = contentElement.select(".yt-lockup-byline > a").text();
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, WATCH_URL_PREFIX + videoId);
        tracks.add(trackFactory.apply(info));
    }

    private List<AudioTrack> polymerExtractTracks(Document document, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        Matcher matcher = this.polymerInitialDataRegex.matcher(document.outerHtml());
        if (!matcher.find()) {
            log.warn("Failed to match ytInitialData JSON object");
            return Collections.emptyList();
        }
        JsonBrowser jsonBrowser = JsonBrowser.parse(matcher.group(2));
        ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        jsonBrowser.get("contents").get("twoColumnSearchResultsRenderer").get("primaryContents").get("sectionListRenderer").get("contents").index(0).get("itemSectionRenderer").get("contents").values().forEach(json -> {
            AudioTrack track = this.extractPolymerData((JsonBrowser)json, trackFactory);
            if (track != null) {
                list.add(track);
            }
        });
        return list;
    }

    private AudioTrack extractPolymerData(JsonBrowser json, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        JsonBrowser renderer = json.get("videoRenderer");
        if (renderer.isNull()) {
            return null;
        }
        String title = renderer.get("title").get("runs").index(0).get("text").text();
        String author = renderer.get("ownerText").get("runs").index(0).get("text").text();
        String lengthText = renderer.get("lengthText").get("simpleText").text();
        if (lengthText == null) {
            return null;
        }
        long duration = DataFormatTools.durationTextToMillis(lengthText);
        String videoId = renderer.get("videoId").text();
        AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, WATCH_URL_PREFIX + videoId);
        return trackFactory.apply(info);
    }
}

