/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public final class Helper {
    public static final ExecutorService EXECUTOR;
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR;
    public static final Gson LGSON;
    public static final Gson GSON;
    static final Pattern EXTRACT_URL;

    private Helper() {
    }

    /*
     * Exception decompiling
     */
    public static Map.Entry<String, String> startAndWaitForProcess(ProcessBuilder builder, long timeout) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map.Entry<ProcessBuilder, InfoPacket> createDownloadBuilder(File defaultDirectory, String args) {
        String[] commands;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        Helper.getOrCreateMediaDir(Config.mediaPath()).ifPresentOrElse(dir -> builder.directory((File)dir), () -> builder.directory(new File("./")));
        boolean downloadable = false;
        boolean temp = false;
        builder.command(Config.DL_YTDLP_PATH, "--ignore-errors", "--progress-delta", "2", "--restrict-filenames", "--embed-metadata", "--embed-thumbnail", "--no-playlist", "--output", "%(title).64s.%(ext)s");
        if (Config.YOUTUBE_USE_COOKIES.booleanValue() && Config.cookiesExists()) {
            builder.command().add("--cookies");
            builder.command().add(Config.getCookies().getAbsolutePath());
        }
        String url = "";
        Matcher matcher = EXTRACT_URL.matcher(args);
        if (matcher.find()) {
            url = matcher.group();
            args = matcher.replaceAll("");
        }
        block20: for (String command : commands = args.split("--")) {
            String[] parse;
            if (command.isEmpty() || (parse = command.trim().split(" ", 2)).length <= 0) continue;
            switch (parse[0]) {
                case "temp": {
                    Helper.getOrCreateMediaDir(Config.tempPath()).ifPresent(dir -> builder.directory((File)dir));
                    temp = true;
                    continue block20;
                }
                case "music": {
                    builder.command().addAll(Arrays.asList("--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K"));
                    Helper.getOrCreateMediaDir(Config.musicPath()).ifPresent(dir -> builder.directory((File)dir));
                    continue block20;
                }
                case "link": {
                    downloadable = true;
                    continue block20;
                }
                case "url": {
                    if (parse.length != 2 || parse[1].isBlank()) continue block20;
                    url = parse[1];
                    continue block20;
                }
                case "cookies": {
                    if (Config.YOUTUBE_USE_COOKIES.booleanValue() || !Config.cookiesExists()) continue block20;
                    builder.command().add("--cookies");
                    builder.command().add(Config.getCookies().getAbsolutePath());
                    continue block20;
                }
                case "yt": {
                    downloadable = false;
                    temp = false;
                    builder.command().addAll(Arrays.asList("--format", "bestvideo[ext=mp4][vcodec=avc1]+bestaudio[ext=m4a]/best[ext=mp4]/best"));
                    Helper.getOrCreateMediaDir(Config.PLAYLIST_PATH).ifPresent(dir -> builder.directory((File)dir));
                    continue block20;
                }
                case "ytc": {
                    downloadable = false;
                    temp = false;
                    builder.command().addAll(Arrays.asList("--f", "bestvideo[ext=mp4][vcodec=avc1]+bestaudio[ext=m4a]/best[ext=mp4]/best"));
                    Helper.getOrCreateMediaDir(Config.PLAYLIST_PATH_CUSTOM).ifPresent(dir -> builder.directory((File)dir));
                    continue block20;
                }
                case "tor": {
                    ANSI.raw("\u001b[36m[INFO]Try using Tor for download... ");
                    if (Config.DL_USE_TOR.booleanValue() && Config.torAccessible()) {
                        ANSI.raw("OK![RESET]");
                        builder.command().add("--proxy");
                        builder.command().add(String.format("socks5://%s:%d", Config.DL_TOR_HOST, Config.DL_TOR_PORT));
                        if (!Config.DL_USE_CTOR.booleanValue()) continue block20;
                        ANSI.raw("\\033[36m[INFO]Try chaning exit node... ");
                        Helper.newTorCircuit();
                        String torIP = Helper.getTorExitNode();
                        if (torIP != null) {
                            ANSI.info(String.format("Now using IP: %s", torIP));
                            continue block20;
                        }
                        ANSI.info("Failed to change Tor IP.");
                        continue block20;
                    }
                    ANSI.info("Not able to use Tor.");
                    continue block20;
                }
                default: {
                    if (!parse[0].isEmpty()) {
                        builder.command().add("--" + parse[0]);
                    }
                    if (parse.length != 2 || parse[1].isEmpty()) continue block20;
                    builder.command().add(parse[1]);
                }
            }
        }
        InfoPacket infoPacket = InfoPacket.build(url);
        if (!url.isEmpty()) {
            builder.command().add(url);
        }
        infoPacket.downloadable = downloadable;
        infoPacket.temp = temp;
        return Map.entry(builder, infoPacket);
    }

    public static byte[] extractImageFromMedia(File media, File dest) {
        ProcessBuilder builder = new ProcessBuilder("ffmpeg", "-v", "quiet", "-i", media.getAbsolutePath(), "-map", "0:v:0", "-c:v", "mjpeg", "-f", "mjpeg", "-");
        byte[] bytes = new byte[]{};
        Process process = null;
        try {
            process = builder.start();
            try (InputStream in = process.getInputStream();
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int h2;
                int w;
                BufferedImage bimage = ImageIO.read(in);
                if (bimage.getWidth() > bimage.getHeight()) {
                    ratio = (double)bimage.getHeight() / (double)bimage.getWidth();
                    w = Config.DL_THUMBNAIL_SIZE.x;
                    h2 = (int)((double)w * ratio);
                } else {
                    ratio = (double)bimage.getWidth() / (double)bimage.getHeight();
                    h2 = Config.DL_THUMBNAIL_SIZE.y;
                    w = (int)((double)h2 * ratio);
                }
                int type = bimage.getType();
                Image temp = bimage.getScaledInstance(w, h2, 4);
                bimage = new BufferedImage(w, h2, type);
                Graphics2D g2d = bimage.createGraphics();
                g2d.drawImage(temp, 0, 0, null);
                g2d.dispose();
                if (dest == null) {
                    if (ImageIO.write((RenderedImage)bimage, "jpg", out)) {
                        bytes = out.toByteArray();
                    }
                } else {
                    ImageIO.write((RenderedImage)bimage, "jpg", dest);
                }
            }
        }
        catch (Exception e) {
            ANSI.error(e.getMessage(), e);
        }
        if (process != null && process.isAlive()) {
            Helper.waitForProcess(process, 10L);
        }
        return bytes;
    }

    public static void waitForProcess(Process process, long timeout) {
        EXECUTOR.submit(() -> {
            try {
                process.waitFor(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ANSI.error(e.getMessage(), e);
                process.destroy();
            }
        });
    }

    public static boolean ytdlpAvail() {
        if (!Helper.ffmpegAvail()) {
            return false;
        }
        ProcessBuilder builder = new ProcessBuilder(Config.DL_YTDLP_PATH, "--version");
        try {
            Process process = builder.start();
            Helper.waitForProcess(process, 10L);
        }
        catch (Exception e) {
            ANSI.warn("YT-DLP not present from systempath.");
            return false;
        }
        return true;
    }

    public static boolean ffmpegAvail() {
        ProcessBuilder builder = new ProcessBuilder("ffmpeg", "-version");
        try {
            Process process = builder.start();
            Helper.waitForProcess(process, 10L);
        }
        catch (Exception e) {
            ANSI.warn("FFMPEG not present from systempath.");
            return false;
        }
        return true;
    }

    public static boolean updateYTDLP() {
        ProcessBuilder builder = new ProcessBuilder("yt-dlp", "--update");
        try {
            Map.Entry<String, String> output = Helper.startAndWaitForProcess(builder, 10L);
            String out = output.getKey();
            String err = output.getValue();
            if (!err.isEmpty()) {
                ANSI.warn(err);
            }
            if (!out.isEmpty()) {
                ANSI.info(out);
            }
        }
        catch (Exception e) {
            ANSI.error("YT-DLP update went wrong!", e);
            return false;
        }
        return true;
    }

    public static Optional<File> getOrCreateMediaDir(String name) {
        block5: {
            try {
                File dir = new File(name).getCanonicalFile();
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (dir.isDirectory()) {
                    return Optional.of(dir);
                }
                if (Config.DEBUG.booleanValue()) {
                    ANSI.warn("Failed to create directory: " + dir.getCanonicalPath());
                }
            }
            catch (IOException e) {
                if (!Config.DEBUG.booleanValue()) break block5;
                ANSI.warn("Failed to get canonical path for directory: " + name);
            }
        }
        return Optional.empty();
    }

    public static String stringFloatToTime(String time) {
        if (time.isEmpty()) {
            return "";
        }
        float duration = 0.0f;
        try {
            duration = Float.parseFloat(time);
        }
        catch (Exception e) {
            ANSI.error(e.getMessage(), e);
        }
        int h2 = (int)(duration / 3600.0f);
        int m3 = (int)(duration % 3600.0f / 60.0f);
        int s2 = (int)(duration % 60.0f);
        return String.format("%02d:%02d:%02d", h2, m3, s2);
    }

    public static List<String> getFilesByPath(String path, boolean sub, String glob) {
        File dir = new File(path);
        ArrayList<String> files = new ArrayList<String>();
        if (dir.exists() && dir.isDirectory()) {
            Helper.addFiles(dir, files, sub, glob);
        }
        return files;
    }

    private static void addFiles(File dir, List<String> files, boolean sub, String glob) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(dir);
        while (!stack.isEmpty()) {
            File current = (File)stack.pop();
            File[] found = current.listFiles();
            if (found == null) continue;
            Stream.of(found).forEach(file -> {
                if (file.isFile() && matcher.matches(Paths.get(file.getName(), new String[0]))) {
                    files.add(current.getName() + "/" + file.getName());
                } else if (sub && file.isDirectory()) {
                    stack.push((File)file);
                }
            });
        }
    }

    public static boolean isUrl(String url) {
        try {
            URI uri = URI.create(url);
            String scheme = uri.getScheme();
            return scheme != null && (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void newTorCircuit() {
        Future<?> future = EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                String host = Config.DL_CTOR_HOST;
                int port = Config.DL_CTOR_PORT;
                String pwd = Config.DL_CTOR_PWD;
                try (Socket socket = new Socket(host, port);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                     PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);){
                    writer.println(String.format("AUTHENTICATE \"%s\"", pwd));
                    ANSI.raw(reader.readLine());
                    writer.println("SIGNAL NEWNYM");
                    ANSI.raw(String.format(" %s[RESET]", reader.readLine()));
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    ANSI.error("Change Tor IP failed: ", e);
                }
            }
        });
        try {
            future.get(3200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            future.cancel(true);
            ANSI.error("Failed to change Tor's exit node. ", e);
        }
    }

    public static String getTorExitNode() {
        String ip = null;
        Future<String> future = EXECUTOR.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String ip = null;
                try {
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(Config.DL_TOR_HOST, (int)Config.DL_TOR_PORT));
                    URL url = URI.create("https://api.ipify.org").toURL();
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
                    conn.setRequestMethod("GET");
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                        ip = br.readLine();
                    }
                }
                catch (Exception e) {
                    ANSI.error("Failed to get Tor's exit node. ", e);
                }
                return ip;
            }
        });
        try {
            ip = future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.error("Failed to get Tor's current exit node. ", e);
        }
        return ip;
    }

    public static void close() {
        ANSI.print("[WHITE]Shutdown task executor...");
        EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE!");
        ANSI.print("[WHITE]Shutdown scheduled task executor...");
        SCHEDULED_EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE![/GREEN]");
    }

    static {
        EXTRACT_URL = Pattern.compile("\\b(https?)://[-A-Z0-9+&@#/%?=~_|!:,.;]*[-A-Z0-9+&@#/%=~_|]", 2);
        EXECUTOR = Executors.newCachedThreadPool();
        SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(1);
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LGSON = new GsonBuilder().setPrettyPrinting().setFieldNamingStrategy(s2 -> s2.getName().toLowerCase()).disableHtmlEscaping().create();
    }
}

