/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.process;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.log.LogMessage;
import com.github.kokorin.jaffree.process.StdReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStdReader<T>
implements StdReader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingStdReader.class);

    @Override
    public T read(InputStream stdOut) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdOut));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.info(line);
            }
        }
        catch (IOException e) {
            throw new JaffreeException("Failed to read stdout (stderr)", e);
        }
        return null;
    }

    @Override
    public List<LogMessage> getErrorLogMessages() {
        return Collections.emptyList();
    }
}

