/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;

@ConsoleCommand(name="b", usage="[status|file|next] -> Info about broadcast status, current file and next file", requireds={Requireds.BROADCASTRUNNER})
public class BroadcastInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        ANSI.println("===Broadcast information===");
        block10: for (int i1 = 0; i1 < args.length; ++i1) {
            switch (args[i1]) {
                case "status": {
                    ANSI.println("Is broadcasting: " + BroadcastRunner.isStreaming());
                    continue block10;
                }
                case "file": {
                    File playling = BroadcastRunner.playing();
                    if (playling != null) {
                        ANSI.println("Current File: " + playling.getName());
                        ANSI.println(FFProbePacket.build(playling).toString());
                        continue block10;
                    }
                    ANSI.println("No file playling.");
                    continue block10;
                }
                case "next": {
                    File next = BroadcastRunner.getFiles()[BroadcastRunner.index.get()];
                    if (next != null) {
                        ANSI.println("Next File: " + next.getName());
                        ANSI.println(FFProbePacket.build(next).toString());
                        continue block10;
                    }
                    ANSI.println("No file to play next.");
                    continue block10;
                }
            }
        }
        return true;
    }
}

