/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.permission;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.permission.User;

public final class Permissions {
    private Permissions() {
    }

    public static class Guilds {
        private Guilds() {
        }

        public static boolean permitted(Long guildId, Long channelId) {
            return Config.DISCORD.PERMITTED_GUILDS.containsKey(guildId) && Config.DISCORD.PERMITTED_GUILDS.get((Object)guildId).channelId.contains(channelId);
        }
    }

    public static class Users {
        private Users() {
        }

        public static boolean permitted(Long id, User.Rank required) {
            if (Config.DISCORD.PERMITTED_USERS.containsKey(id)) {
                User user = Config.DISCORD.PERMITTED_USERS.get(id);
                return user.rank.ordinal() >= required.ordinal();
            }
            return required == User.Rank.GUEST;
        }
    }
}

