/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.retry;

import discord4j.common.retry.ReconnectContext;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.retry.Backoff;
import reactor.retry.BackoffDelay;
import reactor.retry.Jitter;

public class ReconnectOptions {
    public static final Supplier<Scheduler> DEFAULT_BACKOFF_SCHEDULER = () -> Schedulers.newParallel("d4j-backoff", Schedulers.DEFAULT_POOL_SIZE, true);
    private final Duration firstBackoff;
    private final Duration maxBackoffInterval;
    private final long maxRetries;
    private final Backoff backoff;
    private final Jitter jitter;
    private final Scheduler backoffScheduler;
    private final double jitterFactor;

    protected ReconnectOptions(Builder builder) {
        this.firstBackoff = Objects.requireNonNull(builder.firstBackoff, "firstBackoff");
        this.maxBackoffInterval = Objects.requireNonNull(builder.maxBackoffInterval, "maxBackoffInterval");
        this.maxRetries = builder.maxRetries;
        this.backoff = Objects.requireNonNull(builder.backoff, "backoff");
        this.jitter = Objects.requireNonNull(builder.jitter, "jitter");
        this.backoffScheduler = builder.backoffScheduler == null ? DEFAULT_BACKOFF_SCHEDULER.get() : builder.backoffScheduler;
        this.jitterFactor = builder.jitterFactor;
    }

    public static ReconnectOptions create() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Duration getFirstBackoff() {
        return this.firstBackoff;
    }

    public Duration getMaxBackoffInterval() {
        return this.maxBackoffInterval;
    }

    public long getMaxRetries() {
        return this.maxRetries;
    }

    @Deprecated
    public Backoff getBackoff() {
        return this.backoff;
    }

    @Deprecated
    public Jitter getJitter() {
        return this.jitter;
    }

    public Scheduler getBackoffScheduler() {
        return this.backoffScheduler;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public static class Builder {
        private Duration firstBackoff = Duration.ofSeconds(2L);
        private Duration maxBackoffInterval = Duration.ofSeconds(30L);
        private long maxRetries = Long.MAX_VALUE;
        private Backoff backoff = context -> {
            Duration nextBackoff;
            ReconnectContext appContext = (ReconnectContext)context.applicationContext();
            try {
                long factor = (long)Math.pow(2.0, appContext.getAttempts() - 1);
                nextBackoff = appContext.getFirstBackoff().multipliedBy(factor);
            }
            catch (ArithmeticException e) {
                nextBackoff = appContext.getMaxBackoffInterval();
            }
            return new BackoffDelay(appContext.getFirstBackoff(), appContext.getMaxBackoffInterval(), nextBackoff);
        };
        private Jitter jitter = Jitter.random();
        private Scheduler backoffScheduler = null;
        private double jitterFactor = 0.5;

        protected Builder() {
        }

        public Builder setFirstBackoff(Duration firstBackoff) {
            if (firstBackoff.minus(Duration.ofSeconds(2L)).isNegative()) {
                throw new IllegalArgumentException("firstBackoff duration must be at least 2 seconds");
            }
            this.firstBackoff = firstBackoff;
            return this;
        }

        public Builder setMaxBackoffInterval(Duration maxBackoffInterval) {
            if (maxBackoffInterval.minus(this.firstBackoff).isNegative()) {
                throw new IllegalArgumentException("maxBackoffInterval must be at least the same as firstBackoff");
            }
            this.maxBackoffInterval = maxBackoffInterval;
            return this;
        }

        public Builder setMaxRetries(long maxRetries) {
            if (maxRetries < 0L) {
                throw new IllegalArgumentException("maxRetries must be a positive integer");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        @Deprecated
        public Builder setBackoff(Backoff backoff) {
            this.backoff = backoff;
            return this;
        }

        @Deprecated
        public Builder setJitter(Jitter jitter) {
            this.jitter = jitter;
            return this;
        }

        public Builder setBackoffScheduler(Scheduler backoffScheduler) {
            this.backoffScheduler = backoffScheduler;
            return this;
        }

        public Builder setJitterFactor(double jitterFactor) {
            if (jitterFactor < 0.0 || jitterFactor > 1.0) {
                throw new IllegalArgumentException("Invalid jitter factor value");
            }
            this.jitterFactor = jitterFactor;
            return this;
        }

        public ReconnectOptions build() {
            return new ReconnectOptions(this);
        }
    }
}

