/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.BaseInOut;
import com.github.kokorin.jaffree.ffmpeg.Input;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BaseInput<T extends BaseInput<T>>
extends BaseInOut<T>
implements Input {
    private final String input;
    private Integer streamLoop;
    private boolean readAtFrameRate = false;

    public BaseInput(String input) {
        this.input = input;
    }

    public T setStreamLoop(Integer streamLoop) {
        this.streamLoop = streamLoop;
        return (T)((BaseInput)this.thisAsT());
    }

    public T setReadAtFrameRate(boolean readAtFrameRate) {
        this.readAtFrameRate = readAtFrameRate;
        return (T)((BaseInput)this.thisAsT());
    }

    @Override
    public final List<String> buildArguments() {
        ArrayList<String> result = new ArrayList<String>(super.buildArguments());
        if (this.streamLoop != null) {
            result.addAll(Arrays.asList("-stream_loop", this.streamLoop.toString()));
        }
        if (this.readAtFrameRate) {
            result.add("-re");
        }
        result.addAll(this.getAdditionalArguments());
        if (this.input == null) {
            throw new IllegalArgumentException("Input must be specified");
        }
        result.addAll(Arrays.asList("-i", this.input));
        return result;
    }
}

