/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.GuildEmojiEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.UserData;
import discord4j.rest.util.Image;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class GuildEmoji
implements Entity {
    private static final String EMOJI_IMAGE_PATH = "emojis/%s";
    private final GatewayDiscordClient gateway;
    private final EmojiData data;
    private final long guildId;

    public GuildEmoji(GatewayDiscordClient gateway, EmojiData data, long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = guildId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return this.data.id().map(Snowflake::of).orElseThrow(IllegalStateException::new);
    }

    public EmojiData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name().orElseThrow(IllegalStateException::new);
    }

    public Set<Snowflake> getRoleIds() {
        return this.data.roles().toOptional().map(roles -> roles.stream().map(Snowflake::of).collect(Collectors.toSet())).orElseThrow(IllegalStateException::new);
    }

    public Flux<Role> getRoles() {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.gateway.getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Flux<Role> getRoles(EntityRetrievalStrategy retrievalStrategy) {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Mono<User> getUser() {
        UserData user = this.data.user().toOptional().orElseThrow(IllegalStateException::new);
        return this.gateway.getRestClient().getEmojiService().getGuildEmoji(this.getGuildId().asLong(), this.getId().asLong()).map(data -> new User(this.gateway, user));
    }

    public boolean requiresColons() {
        return this.data.requireColons().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isManaged() {
        return this.data.managed().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isAnimated() {
        return this.data.animated().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isAvailable() {
        return this.data.available().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public Mono<GuildEmoji> edit(Consumer<? super GuildEmojiEditSpec> spec) {
        return Mono.defer(() -> {
            GuildEmojiEditSpec mutatedSpec = new GuildEmojiEditSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getEmojiService().modifyGuildEmoji(this.getGuildId().asLong(), this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, this.getGuildId().asLong()));
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getEmojiService().deleteGuildEmoji(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    public String getImageUrl() {
        String path = String.format(EMOJI_IMAGE_PATH, this.getId().asString());
        return this.isAnimated() ? ImageUtil.getUrl(path, Image.Format.GIF) : ImageUtil.getUrl(path, Image.Format.PNG);
    }

    public Mono<Image> getImage() {
        return Image.ofUrl(this.getImageUrl());
    }

    public String asFormat() {
        return '<' + (this.isAnimated() ? "a" : "") + ':' + this.getName() + ':' + this.getId().asString() + '>';
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "GuildEmoji{data=" + this.data + ", guildId=" + this.guildId + '}';
    }
}

