/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.request.DiscordWebResponse;
import discord4j.rest.request.Router;
import discord4j.rest.route.Route;
import discord4j.rest.util.Multimap;
import discord4j.rest.util.RouteUtils;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import reactor.util.annotation.Nullable;

public class DiscordWebRequest {
    private final Route route;
    private final String completeUri;
    private final Map<String, String> uriVariableMap;
    @Nullable
    private Object body;
    @Nullable
    private Multimap<String, Object> queryParams;
    @Nullable
    private Map<String, Set<String>> headers;

    public DiscordWebRequest(Route route, Object ... uriVars) {
        this.route = route;
        this.completeUri = RouteUtils.expand(route.getUriTemplate(), uriVars);
        this.uriVariableMap = RouteUtils.createVariableMap(route.getUriTemplate(), uriVars);
    }

    public Route getRoute() {
        return this.route;
    }

    public String getCompleteUri() {
        return this.completeUri;
    }

    @Nullable
    public Object getBody() {
        return this.body;
    }

    @Nullable
    public Multimap<String, Object> getQueryParams() {
        return this.queryParams;
    }

    @Nullable
    public Map<String, Set<String>> getHeaders() {
        return this.headers;
    }

    public DiscordWebRequest body(Object body) {
        this.body = body;
        return this;
    }

    public DiscordWebRequest query(String key, Object value) {
        if (this.queryParams == null) {
            this.queryParams = new Multimap();
        }
        this.queryParams.add(key, value);
        return this;
    }

    public DiscordWebRequest query(Map<String, Object> params) {
        params.forEach(this::query);
        return this;
    }

    public DiscordWebRequest query(Multimap<String, Object> params) {
        params.forEachElement(this::query);
        return this;
    }

    public DiscordWebRequest header(String key, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Set<String>>();
        }
        this.headers.computeIfAbsent(key.toLowerCase(), k -> new LinkedHashSet()).add(value);
        return this;
    }

    public DiscordWebRequest optionalHeader(String key, @Nullable String value) {
        return value == null ? this : this.header(key, value);
    }

    boolean matchesVariables(Predicate<Map<String, String>> matcher) {
        return matcher.test(this.uriVariableMap);
    }

    public DiscordWebResponse exchange(Router router) {
        return router.exchange(this);
    }

    public String getDescription() {
        return this.route.getMethod() + " " + this.completeUri;
    }

    public String toString() {
        return "DiscordRequest{route=" + this.route + ", completeUri='" + this.completeUri + '\'' + ", body=" + this.body + ", queryParams=" + this.queryParams + ", headers=" + this.headers + '}';
    }
}

