/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.net;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.process.ProcessHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TcpServer
implements ProcessHelper {
    private final ServerSocket serverSocket;
    private final String addressAndPort;
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServer.class);

    protected TcpServer(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
        this.addressAndPort = serverSocket.getInetAddress().getHostAddress() + ":" + serverSocket.getLocalPort();
    }

    @Override
    public final void run() {
        try (ServerSocket toClose = this.serverSocket;
             Socket socket = this.serverSocket.accept();){
            LOGGER.debug("Connection accepted, serving: {}", (Object)this.getAddressAndPort());
            this.serve(socket);
            LOGGER.debug("Served successfully: {}", (Object)this.getAddressAndPort());
        }
        catch (Exception e) {
            throw new JaffreeException("TCP negotiation failed", e);
        }
    }

    protected abstract void serve(Socket var1) throws IOException;

    protected final void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public String getAddressAndPort() {
        return this.addressAndPort;
    }

    public String toString() {
        return "TcpServer{addressAndPort=" + this.addressAndPort + '}';
    }

    protected static ServerSocket allocateSocket() {
        try {
            return new ServerSocket(0, 1, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            throw new JaffreeException("Failed to allocate socket", e);
        }
    }
}

