/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.discordjson.json.ApplicationCommandInteractionData;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.UserData;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;

@Experimental
public class Interaction
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final InteractionData data;

    public Interaction(GatewayDiscordClient gateway, InteractionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public InteractionData getData() {
        return this.data;
    }

    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public Snowflake getApplicationId() {
        return Snowflake.of(this.data.applicationId());
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public Optional<ApplicationCommandInteraction> getCommandInteraction() {
        return this.data.data().toOptional().map(data -> new ApplicationCommandInteraction(this.getClient(), (ApplicationCommandInteractionData)data, this.getGuildId().map(Snowflake::asLong).orElse(null)));
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.gateway::getGuildById);
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.data.channelId().get());
    }

    public Mono<MessageChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Optional<Member> getMember() {
        return this.data.member().toOptional().map(data -> new Member(this.gateway, (MemberData)data, this.getGuildId().get().asLong()));
    }

    public User getUser() {
        UserData userData = this.data.member().isAbsent() ? this.data.user().get() : this.data.member().get().user();
        return new User(this.getClient(), userData);
    }

    public String getToken() {
        return this.data.token();
    }

    public Optional<Message> getMessage() {
        return this.data.message().toOptional().map(data -> new Message(this.gateway, (MessageData)data));
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Type {
        UNKNOWN(-1),
        PING(1),
        APPLICATION_COMMAND(2),
        MESSAGE_COMPONENT(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return PING;
                }
                case 2: {
                    return APPLICATION_COMMAND;
                }
                case 3: {
                    return MESSAGE_COMPONENT;
                }
            }
            return UNKNOWN;
        }
    }
}

