/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.youtube;

import com.gmail.berndivader.streamserver.Helper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class Response<T>
implements Callable<T> {
    private String query;

    public Response(String query) {
        this.query = query;
    }

    @Override
    public T call() throws Exception {
        HttpGet request = new HttpGet(this.query);
        JsonObject json = Helper.httpClient.execute((HttpUriRequest)request, new ResponseHandler<JsonObject>(){

            @Override
            public JsonObject handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                String text = "";
                try (Scanner scanner = new Scanner(response.getEntity().getContent(), StandardCharsets.UTF_8.name());){
                    text = scanner.useDelimiter("\\A").next();
                }
                return JsonParser.parseString(text).getAsJsonObject();
            }
        });
        return this.handle(json);
    }

    protected abstract T handle(JsonObject var1);

    protected abstract T handleErr(JsonObject var1);
}

