/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.InteractionCreateEvent;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.discordjson.json.ImmutableInteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.gateway.ShardInfo;
import discord4j.rest.util.InteractionResponseType;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public class ComponentInteractEvent
extends InteractionCreateEvent {
    public ComponentInteractEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    public String getCustomId() {
        return (String)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getCustomId).orElseThrow(IllegalStateException::new);
    }

    public Message getMessage() {
        return this.getInteraction().getMessage().orElseThrow(IllegalStateException::new);
    }

    public Mono<Void> edit(Consumer<? super InteractionApplicationCommandCallbackSpec> spec) {
        return Mono.defer(() -> {
            InteractionApplicationCommandCallbackSpec mutatedSpec = new InteractionApplicationCommandCallbackSpec();
            this.getClient().getRestClient().getRestResources().getAllowedMentions().ifPresent(mutatedSpec::setAllowedMentions);
            spec.accept(mutatedSpec);
            return this.createInteractionResponse(InteractionResponseType.UPDATE_MESSAGE, mutatedSpec.asRequest());
        });
    }

    @Override
    public Mono<Void> acknowledge() {
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_UPDATE_MESSAGE, null);
    }

    @Override
    public Mono<Void> acknowledgeEphemeral() {
        ImmutableInteractionApplicationCommandCallbackData data = InteractionApplicationCommandCallbackData.builder().flags(Message.Flag.EPHEMERAL.getFlag()).build();
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_UPDATE_MESSAGE, data);
    }
}

