/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.AuditSpec;
import discord4j.rest.util.Multimap;
import java.util.Collection;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class GuildPruneSpec
implements AuditSpec<Multimap<String, Object>> {
    private final Multimap<String, Object> map = new Multimap();
    @Nullable
    private String reason;

    public GuildPruneSpec setDays(int days) {
        this.map.set("days", days);
        return this;
    }

    public GuildPruneSpec addRole(Snowflake roleId) {
        this.map.add("include_roles", roleId.asString());
        return this;
    }

    public GuildPruneSpec addRoles(Collection<Snowflake> roleIds) {
        this.map.addAll("include_roles", roleIds.stream().map(Snowflake::asString).collect(Collectors.toList()));
        return this;
    }

    public GuildPruneSpec setComputePruneCount(boolean enable) {
        this.map.set("compute_prune_count", enable);
        return this;
    }

    public GuildPruneSpec setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Multimap<String, Object> asRequest() {
        return this.map;
    }
}

