/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.youtube.Youtube;
import com.gmail.berndivader.streamserver.youtube.packets.EmptyPacket;
import com.gmail.berndivader.streamserver.youtube.packets.Packet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ConsoleCommand(name="streamby", usage="get livestream by id")
public class LivestreamsById
extends Command {
    @Override
    public boolean execute(String[] args) {
        Packet packet = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) continue;
            Future<Packet> future = Youtube.livestreamsByChannelId(args[i]);
            try {
                packet = future.get(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                return false;
            }
            if (packet != null && !(packet instanceof EmptyPacket)) continue;
            return false;
        }
        return true;
    }
}

