/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.github.kokorin.jaffree.ffprobe.Format;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;

@ConsoleCommand(name="f", usage="")
public class StreamInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        if (BroadcastRunner.isStreaming()) {
            Format format = BroadcastRunner.currentFormat;
            if (format != null) {
                float duration = format.getDuration().floatValue();
                ConsoleRunner.println("===Current playing===");
                block22: for (int i1 = 0; i1 < args.length; ++i1) {
                    switch (args[i1]) {
                        case "title": {
                            ConsoleRunner.println("Title: " + format.getTag("title"));
                            continue block22;
                        }
                        case "artist": {
                            ConsoleRunner.println("Artist:" + format.getTag("artist"));
                            continue block22;
                        }
                        case "date": {
                            ConsoleRunner.println("Date:" + format.getTag("date"));
                            continue block22;
                        }
                        case "comment": {
                            ConsoleRunner.println("Comment:" + format.getTag("comment"));
                            continue block22;
                        }
                        case "playtime": 
                        case "time": {
                            ConsoleRunner.println("Playtime:" + (long)(duration / 60.0f) + ":" + (long)(duration % 60.0f));
                            continue block22;
                        }
                        case "file": {
                            ConsoleRunner.println("File:" + format.getFilename());
                            continue block22;
                        }
                        case "bitrate": 
                        case "bits": {
                            ConsoleRunner.println("Bitrate:" + format.getBitRate());
                            continue block22;
                        }
                        case "format": {
                            ConsoleRunner.println("Format:" + format.getFormatName());
                            continue block22;
                        }
                        default: {
                            ConsoleRunner.println("Title: " + format.getTag("title"));
                            ConsoleRunner.println("Artist:" + format.getTag("artist"));
                            ConsoleRunner.println("Date:" + format.getTag("date"));
                            ConsoleRunner.println("Comment:" + format.getTag("comment"));
                            ConsoleRunner.println("Playtime:" + (long)(duration / 60.0f) + ":" + (long)(duration % 60.0f));
                            ConsoleRunner.println("File:" + format.getFilename());
                            ConsoleRunner.println("Bitrate:" + format.getBitRate());
                            ConsoleRunner.println("Format:" + format.getFormatName());
                        }
                    }
                }
            } else {
                ConsoleRunner.println("No information about stream available.");
            }
        } else {
            ConsoleRunner.println("Currently no stream is running.");
        }
        return true;
    }
}

