/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.gmail.berndivader.streamserver.discord.command.Command;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.rest.util.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

@DiscordCommand(name="dlp")
public class DownloadMedia
extends Command<Void> {
    @Override
    public Mono<Void> execute(String string, MessageChannel channel) {
        Helper.executor.submit(new Runner(string, channel));
        return channel.createEmbed((Consumer<? super EmbedCreateSpec>)new Consumer<EmbedCreateSpec>(){

            @Override
            public void accept(EmbedCreateSpec embed) {
                embed.setTitle("Download media file.");
                embed.setColor(Color.GREEN);
                embed.setDescription("Media file job started.....");
            }
        }).then();
    }

    private class Runner
    implements Runnable {
        private final String line;
        private final MessageChannel channel;

        public Runner(String line, MessageChannel channel) {
            this.line = line;
            this.channel = channel;
        }

        @Override
        public void run() {
            File directory = new File(Config.DL_MUSIC_PATH);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if (!directory.exists() || directory.isFile()) {
                this.channel.createEmbed(embed -> {
                    embed.setTitle("ERROR DLP!");
                    embed.setColor(Color.RED);
                    embed.setDescription("There was an issue with the download directory configured in Config.DL_MUSIC_PATH. It is either a file or the directory couldnt be created by the bot.");
                }).subscribe();
                return;
            }
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(directory);
            builder.command("yt-dlp", "--ignore-errors", "--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K", "--output", "%(title)s.%(ext)s", "--restrict-filenames", "--no-playlist");
            String[] temp = this.line.split(" --");
            for (int i = 0; i < temp.length; ++i) {
                if (!temp[i].startsWith("--")) {
                    temp[i] = "--".concat(temp[i]);
                }
                String[] parse = temp[i].split(" ", 2);
                for (int j = 0; j < parse.length; ++j) {
                    if (parse[j].equals("--url")) continue;
                    builder.command().add(parse[j]);
                }
            }
            try {
                Message message = this.channel.createMessage(msg -> msg.setContent("Starting download...")).block();
                if (message == null) {
                    return;
                }
                Process process = builder.start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    while (process.isAlive()) {
                        String out = reader.readLine();
                        if (out == null || !out.startsWith("[youtube:tab]") && !out.startsWith("[download]")) continue;
                        message.edit(msg -> msg.setContent(out)).subscribe();
                    }
                }
                reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    reader.lines().forEach(line -> ConsoleRunner.printErr(line));
                }
                finally {
                    reader.close();
                }
                process.destroy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

