/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

final class MonoSumDouble<T>
extends MonoFromFluxOperator<T, Double>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumDouble(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Double> s) {
        this.source.subscribe(new SumLongSubscriber<T>(s, this.mapping));
    }

    static final class SumLongSubscriber<T>
    extends MathSubscriber<T, Double> {
        final Function<? super T, ? extends Number> mapping;
        double sum;
        boolean hasValue;

        SumLongSubscriber(CoreSubscriber<? super Double> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            double doubleValue = this.mapping.apply(newValue).doubleValue();
            this.sum = this.hasValue ? this.sum + doubleValue : doubleValue;
            this.hasValue = true;
        }

        @Override
        protected Double result() {
            return this.hasValue ? Double.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0.0;
            this.hasValue = false;
        }
    }
}

