/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command;

import com.gmail.berndivader.streamserver.StreamServer;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.gmail.berndivader.streamserver.discord.command.Command;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Commands {
    public static Commands instance;
    private static final String PACKAGE_NAME = "com/gmail/berndivader/streamserver/discord/command/commands";
    private static String fileName;
    public HashMap<String, Class<Command<?>>> commands;

    public Commands() {
        instance = this;
        this.commands = new HashMap();
        this.loadCommandClasses();
    }

    private void loadCommandClasses() {
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(fileName));){
            while (jarStream.available() == 1) {
                Class<?> clazz;
                DiscordCommand anno;
                String clazzName;
                JarEntry entry = jarStream.getNextJarEntry();
                if (entry == null || !(clazzName = entry.getName()).endsWith(".class") || !clazzName.startsWith(PACKAGE_NAME) || (anno = (clazz = Class.forName(clazzName = clazzName.substring(0, clazzName.length() - 6).replace("/", "."))).getAnnotation(DiscordCommand.class)) == null) continue;
                this.commands.put(anno.name(), clazz);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Command<?> newCommandInstance(String name) {
        Class<Command<?>> command;
        if (name.isEmpty()) {
            name = "help";
        }
        if ((command = this.commands.get(name)) == null) {
            return null;
        }
        try {
            return command.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ConsoleRunner.println(e.getMessage());
            return null;
        }
    }

    static {
        try {
            fileName = URLDecoder.decode(StreamServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            try {
                fileName = URLDecoder.decode(StreamServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.ISO_8859_1.toString());
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
    }
}

