/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.gmail.berndivader.streamserver.discord.command.Command;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.rest.util.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import reactor.core.publisher.Mono;

@DiscordCommand(name="dlp", usage="Download media. [--yes-playlist] --url <valid_url>")
public class DownloadMedia
extends Command<Void> {
    @Override
    public Mono<Void> execute(String string, MessageChannel channel) {
        Helper.executor.submit(new Runner(string, channel));
        return Mono.empty();
    }

    private class Runner
    implements Runnable {
        private final String line;
        private final MessageChannel channel;

        public Runner(String line, MessageChannel channel) {
            this.line = line;
            this.channel = channel;
        }

        @Override
        public void run() {
            File directory = new File(Config.DL_MUSIC_PATH);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if (!directory.exists() || directory.isFile()) {
                this.channel.createMessage(msg -> msg.addEmbed(embed -> {
                    embed.setTitle("ERROR DLP!");
                    embed.setColor(Color.RED);
                    embed.setDescription("There was an issue with the download directory configured in Config.DL_MUSIC_PATH. It is either a file or the directory couldnt be created by the bot.");
                })).subscribe();
                return;
            }
            Message message = this.channel.createMessage(msg -> msg.addEmbed(embed -> {
                embed.setTitle("Prepare download media file.");
                embed.setColor(Color.GREEN);
            })).block();
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(directory);
            builder.command("yt-dlp", "--ignore-errors", "--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K", "--output", "%(title)s.%(ext)s", "--restrict-filenames", "--no-playlist");
            String[] temp = this.line.split(" --");
            for (int i = 0; i < temp.length; ++i) {
                if (!temp[i].startsWith("--")) {
                    temp[i] = "--".concat(temp[i]);
                }
                String[] parse = temp[i].split(" ", 2);
                for (int j = 0; j < parse.length; ++j) {
                    if (parse[j].equals("--url")) continue;
                    builder.command().add(parse[j]);
                }
            }
            try {
                message.edit(msg -> msg.setContent("Starting download...")).subscribe();
                Process process = builder.start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    while (process.isAlive()) {
                        String filename;
                        String out = reader.readLine();
                        if (out == null) continue;
                        if (out.startsWith("[download] Destination:")) {
                            filename = out.substring(23);
                            message.edit(msg -> {
                                msg.removeEmbeds();
                                msg.addEmbed(embed -> {
                                    embed.setTitle("Downloading");
                                    embed.setDescription(filename);
                                    embed.setColor(Color.BLUE);
                                });
                            }).subscribe();
                            continue;
                        }
                        if (out.startsWith("[ExtractAudio] Destination:")) {
                            filename = out.substring(27);
                            message.edit(msg -> {
                                msg.removeEmbeds();
                                msg.setContent("");
                                msg.addEmbed(embed -> {
                                    embed.setTitle("Media download finished.");
                                    embed.setDescription(filename);
                                    embed.setColor(Color.GREEN);
                                });
                            }).subscribe();
                            continue;
                        }
                        if (!out.startsWith("[youtube:tab]") && !out.startsWith("[download]")) continue;
                        message.edit(msg -> msg.setContent(out)).subscribe();
                    }
                }
                reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    reader.lines().forEach(line -> ConsoleRunner.printErr(line));
                }
                finally {
                    reader.close();
                }
                process.destroy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

