/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.RoleTags;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.RoleEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.OrderUtil;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleTagsData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestRole;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class Role
implements Entity {
    public static final Color DEFAULT_COLOR = Color.of(0);
    private final GatewayDiscordClient gateway;
    private final RoleData data;
    private final RestRole rest;
    private final long guildId;

    public Role(GatewayDiscordClient gateway, RoleData data, long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.rest = RestRole.create((RestClient)gateway.rest(), Snowflake.of(guildId), Snowflake.of(data.id()));
        this.guildId = guildId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public RoleData getData() {
        return this.data;
    }

    public int getRawPosition() {
        return this.data.position();
    }

    public Mono<Integer> getPosition() {
        return this.getGuild().flatMapMany(Guild::getRoles).transform(OrderUtil::orderRoles).collectList().map(roles -> roles.indexOf(this));
    }

    public Mono<Integer> getPosition(EntityRetrievalStrategy retrievalStrategy) {
        return this.getGuild(retrievalStrategy).flatMapMany(guild -> guild.getRoles(retrievalStrategy)).transform(OrderUtil::orderRoles).collectList().map(roles -> roles.indexOf(this));
    }

    public String getName() {
        return this.data.name();
    }

    public Color getColor() {
        return Color.of(this.data.color());
    }

    public boolean isHoisted() {
        return this.data.hoist();
    }

    public PermissionSet getPermissions() {
        return PermissionSet.of(this.data.permissions());
    }

    public boolean isManaged() {
        return this.data.managed();
    }

    public boolean isMentionable() {
        return this.data.mentionable();
    }

    public boolean isEveryone() {
        return this.getId().equals(this.getGuildId());
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public String getMention() {
        return "<@&" + this.getId().asString() + ">";
    }

    public Optional<RoleTags> getTags() {
        return this.data.tags().toOptional().map(data -> new RoleTags(this.gateway, (RoleTagsData)data));
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public Mono<Role> edit(Consumer<? super RoleEditSpec> spec) {
        return Mono.defer(() -> {
            RoleEditSpec mutatedSpec = new RoleEditSpec();
            spec.accept(mutatedSpec);
            return this.rest.edit(mutatedSpec.asRequest(), mutatedSpec.getReason()).map(bean -> new Role(this.gateway, (RoleData)bean, this.getGuildId().asLong()));
        });
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.rest.delete(reason);
    }

    public Flux<Role> changePosition(int position) {
        return this.rest.changePosition(position).map(data -> new Role(this.gateway, (RoleData)data, this.getGuildId().asLong()));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Role{data=" + this.data + ", guildId=" + this.guildId + '}';
    }
}

