/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.JdkKeyStore;
import discord4j.core.shard.KeyStore;
import discord4j.core.shard.KeyStoreRegistry;
import discord4j.store.api.Store;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JdkKeyStoreRegistry
implements KeyStoreRegistry {
    private final Map<Class<?>, Store<?, ?>> valueStore = new ConcurrentHashMap();
    private final Map<Class<?>, KeyStore<?>> keyStores = new ConcurrentHashMap();

    @Override
    public boolean containsStore(Class<?> valueClass) {
        return this.valueStore.containsKey(valueClass);
    }

    @Override
    public <V, K extends Comparable<K>> void putStore(Class<V> valueClass, Store<K, V> store) {
        this.valueStore.put(valueClass, store);
    }

    @Override
    public <K extends Comparable<K>, V> Store<K, V> getValueStore(Class<K> key, Class<V> value) {
        return this.valueStore.get(value);
    }

    @Override
    public <K extends Comparable<K>, V> KeyStore<K> getKeyStore(Class<V> valueClass) {
        return this.keyStores.computeIfAbsent(valueClass, k -> new JdkKeyStore());
    }
}

