/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.channel.BaseGuildMessageChannel;
import discord4j.core.spec.TextChannelEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public final class TextChannel
extends BaseGuildMessageChannel {
    public TextChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public int getRateLimitPerUser() {
        return this.getData().rateLimitPerUser().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isNsfw() {
        return this.getData().nsfw().toOptional().orElse(false);
    }

    public Mono<TextChannel> edit(Consumer<? super TextChannelEditSpec> spec) {
        return Mono.defer(() -> {
            TextChannelEditSpec mutatedSpec = new TextChannelEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(bean -> EntityUtil.getChannel(this.getClient(), bean)).cast(TextChannel.class);
    }

    @Override
    public String toString() {
        return "TextChannel{} " + super.toString();
    }
}

