/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import com.github.kokorin.jaffree.Rational;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class StreamHeader {
    public final int streamId;
    public final Type streamType;
    public final byte[] fourcc;
    public final int timeBaseId;
    public final int msbPtsShift;
    public final long maxPtsDistance;
    public final long decodeDelay;
    public final Set<Flag> flags;
    public final byte[] codecSpecificData;
    public final Video video;
    public final Audio audio;

    public StreamHeader(int streamId, Type streamType, byte[] fourcc, int timeBaseId, int msbPtsShift, long maxPtsDistance, long decodeDelay, Set<Flag> flags, byte[] codecSpecificData, Video video, Audio audio) {
        this.streamId = streamId;
        this.streamType = streamType;
        this.fourcc = fourcc;
        this.timeBaseId = timeBaseId;
        this.msbPtsShift = msbPtsShift;
        this.maxPtsDistance = maxPtsDistance;
        this.decodeDelay = decodeDelay;
        this.flags = flags;
        this.codecSpecificData = codecSpecificData;
        this.video = video;
        this.audio = audio;
    }

    public String toString() {
        return "StreamHeader{streamId=" + this.streamId + ", streamType=" + (Object)((Object)this.streamType) + ", fourcc=" + Arrays.toString(this.fourcc) + ", timeBaseId=" + this.timeBaseId + ", msbPtsShift=" + this.msbPtsShift + ", maxPtsDistance=" + this.maxPtsDistance + ", decodeDelay=" + this.decodeDelay + ", flags=" + this.flags + ", codecSpecificData=" + Arrays.toString(this.codecSpecificData) + ", video=" + this.video + ", audio=" + this.audio + '}';
    }

    public static enum ColourspaceType {
        UNKNOWN(0L),
        ITU_624(1L),
        ITU_709(2L),
        ITU_624_255(17L),
        ITU_709_255(18L);

        public final long code;

        private ColourspaceType(long code) {
            this.code = code;
        }

        public static ColourspaceType fromCode(long code) {
            for (ColourspaceType type : ColourspaceType.values()) {
                if (code != type.code) continue;
                return type;
            }
            return null;
        }
    }

    public static enum Flag {
        FIXED_FPS(1L);

        private final long code;

        private Flag(long code) {
            this.code = code;
        }

        public static Set<Flag> fromBitCode(long value) {
            if (value == Flag.FIXED_FPS.code) {
                return Collections.singleton(FIXED_FPS);
            }
            return Collections.emptySet();
        }

        public static long toBitCode(Set<Flag> flags) {
            long result = 0L;
            for (Flag flag : flags) {
                result += flag.code;
            }
            return result;
        }
    }

    public static enum Type {
        VIDEO(0L),
        AUDIO(1L),
        SUBTITLES(2L),
        USER_DATA(4L);

        public final long code;

        private Type(long code) {
            this.code = code;
        }

        public static Type fromCode(long code) {
            for (Type type : Type.values()) {
                if (type.code != code) continue;
                return type;
            }
            return null;
        }
    }

    public static class Audio {
        public final Rational sampleRate;
        public final int channelCount;

        public Audio(Rational sampleRate, int channelCount) {
            this.sampleRate = sampleRate;
            this.channelCount = channelCount;
        }

        public String toString() {
            return "Audio{samplerate=" + this.sampleRate + ", channelCount=" + this.channelCount + '}';
        }
    }

    public static class Video {
        public final int width;
        public final int height;
        public final int sampleWidth;
        public final int sampleHeight;
        public final ColourspaceType type;

        public Video(int width, int height, int sampleWidth, int sampleHeight, ColourspaceType type) {
            this.width = width;
            this.height = height;
            this.sampleWidth = sampleWidth;
            this.sampleHeight = sampleHeight;
            this.type = type;
        }

        public String toString() {
            return "Video{width=" + this.width + ", height=" + this.height + ", sampleWidth=" + this.sampleWidth + ", sampleHeight=" + this.sampleHeight + ", type=" + (Object)((Object)this.type) + '}';
        }
    }
}

