/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.json.RegionData;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class Region
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final RegionData data;

    public Region(GatewayDiscordClient gateway, RegionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public RegionData getData() {
        return this.data;
    }

    public String getId() {
        return this.data.id();
    }

    public String getName() {
        return this.data.name();
    }

    public boolean isVip() {
        return this.data.vip();
    }

    public boolean isOptimal() {
        return this.data.optimal();
    }

    public boolean isDeprecated() {
        return this.data.deprecated();
    }

    public boolean isCustom() {
        return this.data.custom();
    }

    public String toString() {
        return "Region{data=" + this.data + '}';
    }

    public static enum Id {
        UNKNOWN(null),
        AUTOMATIC(null),
        US_WEST("us-west"),
        US_EAST("us-east"),
        US_CENTRAL("us-central"),
        US_SOUTH("us-south"),
        SINGAPORE("singapore"),
        SOUTHAFRICA("southafrica"),
        SYDNEY("sydney"),
        EUROPE("europe"),
        BRAZIL("brazil"),
        HONGKONG("hongkong"),
        RUSSIA("russia"),
        JAPAN("japan"),
        INDIA("india");

        private final String value;

        private Id(String value) {
            this.value = value;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public static Id of(@Nullable String value) {
            if (value == null) {
                return AUTOMATIC;
            }
            switch (value) {
                case "us-west": {
                    return US_WEST;
                }
                case "us-east": {
                    return US_EAST;
                }
                case "us-central": {
                    return US_CENTRAL;
                }
                case "us-south": {
                    return US_SOUTH;
                }
                case "singapore": {
                    return SINGAPORE;
                }
                case "southafrica": {
                    return SOUTHAFRICA;
                }
                case "sydney": {
                    return SYDNEY;
                }
                case "europe": {
                    return EUROPE;
                }
                case "brazil": {
                    return BRAZIL;
                }
                case "hongkong": {
                    return HONGKONG;
                }
                case "russia": {
                    return RUSSIA;
                }
                case "japan": {
                    return JAPAN;
                }
                case "india": {
                    return INDIA;
                }
            }
            return UNKNOWN;
        }
    }
}

