/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.GatewayClientGroupManager;
import discord4j.core.shard.ShardingGatewayClientGroup;
import discord4j.core.shard.ShardingStrategy;
import discord4j.gateway.ShardInfo;
import discord4j.rest.RestClient;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultShardingStrategy
implements ShardingStrategy {
    private final int count;
    private final Function<Integer, Publisher<Integer>> indexSource;
    private final Predicate<ShardInfo> filter;
    private final int maxConcurrency;

    public DefaultShardingStrategy(Builder builder) {
        this.count = builder.shardCount;
        this.indexSource = builder.shardIndexSource;
        this.filter = builder.shardFilter;
        this.maxConcurrency = builder.maxConcurrency;
    }

    @Override
    public Mono<Integer> getShardCount(RestClient restClient) {
        if (this.count > 0) {
            return Mono.just(this.count);
        }
        if (this.count == 0) {
            return restClient.getGatewayService().getGatewayBot().map(data -> data.shards().get());
        }
        return Mono.error(new RuntimeException("Invalid shard count: " + this.count));
    }

    @Override
    public Flux<ShardInfo> getShards(int shardCount) {
        return Flux.from(this.indexSource.apply(shardCount)).filter(index -> index >= 0 && index < shardCount).map(index -> ShardInfo.create(index, shardCount)).filter(this.filter);
    }

    @Override
    public GatewayClientGroupManager getGroupManager(int count) {
        return new ShardingGatewayClientGroup(count);
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public static class Builder {
        static int RECOMMENDED_SHARD_COUNT = 0;
        private int shardCount = RECOMMENDED_SHARD_COUNT;
        private Function<Integer, Publisher<Integer>> shardIndexSource = count -> Flux.range(0, count);
        private Predicate<ShardInfo> shardFilter = shard -> true;
        private int maxConcurrency = 1;

        public Builder count(int shardCount) {
            if (shardCount < 0) {
                throw new IllegalArgumentException("shardCount < 0");
            }
            this.shardCount = shardCount;
            return this;
        }

        public Builder indices(int ... shardIndices) {
            this.shardIndexSource = count -> Flux.fromStream(Arrays.stream(shardIndices).boxed());
            return this;
        }

        public Builder indices(Function<Integer, Publisher<Integer>> shardIndexSource) {
            this.shardIndexSource = Objects.requireNonNull(shardIndexSource);
            return this;
        }

        public Builder filter(Predicate<ShardInfo> shardFilter) {
            this.shardFilter = Objects.requireNonNull(shardFilter);
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            if (maxConcurrency < 1) {
                throw new IllegalArgumentException("maxConcurrency < 1");
            }
            if ((maxConcurrency & maxConcurrency - 1) != 0) {
                throw new IllegalArgumentException("maxConcurrency must be a power of 2");
            }
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public ShardingStrategy build() {
            return new DefaultShardingStrategy(this);
        }
    }
}

