/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.ApplicationCommandDispatchHandlers;
import discord4j.core.event.dispatch.ChannelDispatchHandlers;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.dispatch.DispatchEventMapper;
import discord4j.core.event.dispatch.DispatchHandler;
import discord4j.core.event.dispatch.GuildDispatchHandlers;
import discord4j.core.event.dispatch.LifecycleDispatchHandlers;
import discord4j.core.event.dispatch.MessageDispatchHandlers;
import discord4j.core.event.domain.Event;
import discord4j.core.event.domain.InviteCreateEvent;
import discord4j.core.event.domain.InviteDeleteEvent;
import discord4j.core.event.domain.PresenceUpdateEvent;
import discord4j.core.event.domain.UserUpdateEvent;
import discord4j.core.event.domain.VoiceServerUpdateEvent;
import discord4j.core.event.domain.VoiceStateUpdateEvent;
import discord4j.core.event.domain.WebhooksUpdateEvent;
import discord4j.core.event.domain.channel.TypingStartEvent;
import discord4j.core.event.domain.integration.IntegrationCreateEvent;
import discord4j.core.event.domain.integration.IntegrationDeleteEvent;
import discord4j.core.event.domain.integration.IntegrationUpdateEvent;
import discord4j.core.event.domain.interaction.ButtonInteractEvent;
import discord4j.core.event.domain.interaction.ComponentInteractEvent;
import discord4j.core.event.domain.interaction.InteractionCreateEvent;
import discord4j.core.event.domain.interaction.SelectMenuInteractEvent;
import discord4j.core.event.domain.interaction.SlashCommandEvent;
import discord4j.core.object.VoiceState;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Integration;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.presence.Presence;
import discord4j.discordjson.json.ImmutableUserData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ApplicationCommandCreate;
import discord4j.discordjson.json.gateway.ApplicationCommandDelete;
import discord4j.discordjson.json.gateway.ApplicationCommandUpdate;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelPinsUpdate;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.GuildBanAdd;
import discord4j.discordjson.json.gateway.GuildBanRemove;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildIntegrationsUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.IntegrationCreate;
import discord4j.discordjson.json.gateway.IntegrationDelete;
import discord4j.discordjson.json.gateway.IntegrationUpdate;
import discord4j.discordjson.json.gateway.InteractionCreate;
import discord4j.discordjson.json.gateway.InviteCreate;
import discord4j.discordjson.json.gateway.InviteDelete;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.Resumed;
import discord4j.discordjson.json.gateway.TypingStart;
import discord4j.discordjson.json.gateway.UnavailableGuildCreate;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceServerUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.discordjson.json.gateway.WebhooksUpdate;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.retry.GatewayStateChange;
import discord4j.store.api.util.LongLongTuple2;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.function.Tuples;

public class DispatchHandlers
implements DispatchEventMapper {
    private static final Map<Class<?>, DispatchHandler<?, ?>> handlerMap = new HashMap();
    private static final Logger log;

    private static <D, E extends Event> void addHandler(Class<D> dispatchType, DispatchHandler<D, E> dispatchHandler) {
        handlerMap.put(dispatchType, dispatchHandler);
    }

    @Override
    public <D, E extends Event> Mono<E> handle(DispatchContext<D> context) {
        DispatchHandler handler = handlerMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(context.getDispatch().getClass())).map(Map.Entry::getValue).findFirst().orElse(null);
        if (handler == null) {
            log.warn("Handler not found from: {}", context.getDispatch().getClass());
            return Mono.empty();
        }
        return Mono.defer(() -> handler.handle(context)).checkpoint("Dispatch handled for " + context.getDispatch().getClass());
    }

    private static Mono<PresenceUpdateEvent> presenceUpdate(DispatchContext<PresenceUpdate> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        PartialUserData userData = context.getDispatch().user();
        long userId = Snowflake.asLong(userData.id());
        LongLongTuple2 key = LongLongTuple2.of(guildId, userId);
        PresenceData presenceData = DispatchHandlers.createPresence(context.getDispatch());
        Presence current = new Presence(presenceData);
        Mono<Void> saveNew = context.getStateHolder().getPresenceStore().save(key, presenceData);
        Mono<Optional<Optional>> saveUser = context.getStateHolder().getUserStore().find(userId).map(oldUserData -> {
            ImmutableUserData newUserData = UserData.builder().from((UserData)oldUserData).username(userData.username().toOptional().orElse(oldUserData.username())).discriminator(userData.discriminator().toOptional().orElse(oldUserData.discriminator())).avatar(userData.avatar().isAbsent() ? oldUserData.avatar() : Possible.flatOpt(userData.avatar())).build();
            return Tuples.of(oldUserData, newUserData);
        }).flatMap(tuple -> context.getStateHolder().getUserStore().save(userId, (UserData)tuple.getT2()).thenReturn((UserData)tuple.getT1())).map(userBean -> new User(gateway, (UserData)userBean)).map(Optional::of).defaultIfEmpty(Optional.empty());
        return saveUser.flatMap(oldUser -> context.getStateHolder().getPresenceStore().find(key).flatMap(saveNew::thenReturn).map(old -> new PresenceUpdateEvent(gateway, context.getShardInfo(), guildId, oldUser.orElse(null), userData, current, new Presence((PresenceData)old))).switchIfEmpty(saveNew.thenReturn(new PresenceUpdateEvent(gateway, context.getShardInfo(), guildId, oldUser.orElse(null), userData, current, null))));
    }

    private static PresenceData createPresence(PresenceUpdate update) {
        return PresenceData.builder().user(update.user()).roles(update.roles()).game(update.game()).status(update.status()).activities(update.activities()).clientStatus(update.clientStatus()).premiumSince(update.premiumSince()).nick(update.nick()).build();
    }

    private static Mono<TypingStartEvent> typingStart(DispatchContext<TypingStart> context) {
        long channelId = Snowflake.asLong(context.getDispatch().channelId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        long userId = Snowflake.asLong(context.getDispatch().userId());
        Instant startTime = Instant.ofEpochSecond(context.getDispatch().timestamp());
        Member member = context.getDispatch().member().toOptional().filter(__ -> guildId != null).map(memberData -> new Member(context.getGateway(), (MemberData)memberData, guildId)).orElse(null);
        return Mono.just(new TypingStartEvent(context.getGateway(), context.getShardInfo(), channelId, guildId, userId, startTime, member));
    }

    private static Mono<UserUpdateEvent> userUpdate(DispatchContext<UserUpdate> context) {
        GatewayDiscordClient gateway = context.getGateway();
        UserData userData = context.getDispatch().user();
        long userId = Snowflake.asLong(userData.id());
        User current = new User(gateway, userData);
        Mono<Void> saveNew = context.getStateHolder().getUserStore().save(userId, userData);
        return context.getStateHolder().getUserStore().find(userId).flatMap(saveNew::thenReturn).map(old -> new UserUpdateEvent(gateway, context.getShardInfo(), current, new User(gateway, (UserData)old))).switchIfEmpty(saveNew.thenReturn(new UserUpdateEvent(gateway, context.getShardInfo(), current, null)));
    }

    private static Mono<Event> voiceServerUpdate(DispatchContext<VoiceServerUpdate> context) {
        String token = context.getDispatch().token();
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        String endpoint = context.getDispatch().endpoint();
        return Mono.just(new VoiceServerUpdateEvent(context.getGateway(), context.getShardInfo(), token, guildId, endpoint));
    }

    private static Mono<VoiceStateUpdateEvent> voiceStateUpdateDispatch(DispatchContext<VoiceStateUpdateDispatch> context) {
        GatewayDiscordClient gateway = context.getGateway();
        VoiceStateData voiceStateData = context.getDispatch().voiceState();
        long guildId = Snowflake.asLong(voiceStateData.guildId().get());
        long userId = Snowflake.asLong(voiceStateData.userId());
        LongLongTuple2 key = LongLongTuple2.of(guildId, userId);
        VoiceState current = new VoiceState(gateway, voiceStateData);
        Mono<Void> saveNewOrRemove = voiceStateData.channelId().isPresent() ? context.getStateHolder().getVoiceStateStore().save(key, voiceStateData) : context.getStateHolder().getVoiceStateStore().delete(key);
        return context.getStateHolder().getVoiceStateStore().find(key).flatMap(saveNewOrRemove::thenReturn).map(old -> new VoiceStateUpdateEvent(gateway, context.getShardInfo(), current, new VoiceState(gateway, (VoiceStateData)old))).switchIfEmpty(saveNewOrRemove.thenReturn(new VoiceStateUpdateEvent(gateway, context.getShardInfo(), current, null)));
    }

    private static Mono<Event> webhooksUpdate(DispatchContext<WebhooksUpdate> context) {
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        long channelId = Snowflake.asLong(context.getDispatch().channelId());
        return Mono.just(new WebhooksUpdateEvent(context.getGateway(), context.getShardInfo(), guildId, channelId));
    }

    private static Mono<InviteCreateEvent> inviteCreate(DispatchContext<InviteCreate> context) {
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        long channelId = Snowflake.asLong(context.getDispatch().channelId());
        String code = context.getDispatch().code();
        Instant createdAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)context.getDispatch().createdAt(), Instant::from);
        int uses = context.getDispatch().uses();
        int maxUses = context.getDispatch().maxUses();
        int maxAge = context.getDispatch().maxAge();
        boolean temporary = context.getDispatch().temporary();
        User current = context.getDispatch().inviter().toOptional().map(userData -> new User(context.getGateway(), (UserData)userData)).orElse(null);
        return Mono.just(new InviteCreateEvent(context.getGateway(), context.getShardInfo(), guildId, channelId, code, current, createdAt, uses, maxUses, maxAge, temporary));
    }

    private static Mono<InviteDeleteEvent> inviteDelete(DispatchContext<InviteDelete> context) {
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        long channelId = Snowflake.asLong(context.getDispatch().channelId());
        String code = context.getDispatch().code();
        return Mono.just(new InviteDeleteEvent(context.getGateway(), context.getShardInfo(), guildId, channelId, code));
    }

    private static Mono<InteractionCreateEvent> interactionCreate(DispatchContext<InteractionCreate> context) {
        GatewayDiscordClient gateway = context.getGateway();
        Interaction interaction = new Interaction(gateway, context.getDispatch().interaction());
        switch (interaction.getType()) {
            case APPLICATION_COMMAND: {
                return Mono.just(new SlashCommandEvent(gateway, context.getShardInfo(), interaction));
            }
            case MESSAGE_COMPONENT: {
                MessageComponent.Type type = (MessageComponent.Type)((Object)interaction.getCommandInteraction().flatMap(ApplicationCommandInteraction::getComponentType).orElseThrow(IllegalStateException::new));
                switch (type) {
                    case BUTTON: {
                        return Mono.just(new ButtonInteractEvent(gateway, context.getShardInfo(), interaction));
                    }
                    case SELECT_MENU: {
                        return Mono.just(new SelectMenuInteractEvent(gateway, context.getShardInfo(), interaction));
                    }
                }
                return Mono.just(new ComponentInteractEvent(gateway, context.getShardInfo(), interaction));
            }
        }
        return Mono.just(new InteractionCreateEvent(gateway, context.getShardInfo(), interaction));
    }

    private static Mono<IntegrationDeleteEvent> integrationDelete(DispatchContext<IntegrationDelete> context) {
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        long id = Snowflake.asLong(context.getDispatch().id());
        Long applicationId = context.getDispatch().applicationId().toOptional().map(Snowflake::asLong).orElse(null);
        return Mono.just(new IntegrationDeleteEvent(context.getGateway(), context.getShardInfo(), id, guildId, applicationId));
    }

    private static Mono<IntegrationUpdateEvent> integrationUpdate(DispatchContext<IntegrationUpdate> context) {
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        Integration integration = new Integration(context.getGateway(), context.getDispatch().integration(), guildId);
        return Mono.just(new IntegrationUpdateEvent(context.getGateway(), context.getShardInfo(), guildId, integration));
    }

    private static Mono<IntegrationCreateEvent> integrationCreate(DispatchContext<IntegrationCreate> context) {
        long guildId = Snowflake.asLong(context.getDispatch().guildId());
        Integration integration = new Integration(context.getGateway(), context.getDispatch().integration(), guildId);
        return Mono.just(new IntegrationCreateEvent(context.getGateway(), context.getShardInfo(), guildId, integration));
    }

    static {
        DispatchHandlers.addHandler(ChannelCreate.class, ChannelDispatchHandlers::channelCreate);
        DispatchHandlers.addHandler(ChannelDelete.class, ChannelDispatchHandlers::channelDelete);
        DispatchHandlers.addHandler(ChannelPinsUpdate.class, ChannelDispatchHandlers::channelPinsUpdate);
        DispatchHandlers.addHandler(ChannelUpdate.class, ChannelDispatchHandlers::channelUpdate);
        DispatchHandlers.addHandler(GuildBanAdd.class, GuildDispatchHandlers::guildBanAdd);
        DispatchHandlers.addHandler(GuildBanRemove.class, GuildDispatchHandlers::guildBanRemove);
        DispatchHandlers.addHandler(GuildCreate.class, GuildDispatchHandlers::guildCreate);
        DispatchHandlers.addHandler(GuildDelete.class, GuildDispatchHandlers::guildDelete);
        DispatchHandlers.addHandler(GuildEmojisUpdate.class, GuildDispatchHandlers::guildEmojisUpdate);
        DispatchHandlers.addHandler(GuildIntegrationsUpdate.class, GuildDispatchHandlers::guildIntegrationsUpdate);
        DispatchHandlers.addHandler(GuildMemberAdd.class, GuildDispatchHandlers::guildMemberAdd);
        DispatchHandlers.addHandler(GuildMemberRemove.class, GuildDispatchHandlers::guildMemberRemove);
        DispatchHandlers.addHandler(GuildMembersChunk.class, GuildDispatchHandlers::guildMembersChunk);
        DispatchHandlers.addHandler(GuildMemberUpdate.class, GuildDispatchHandlers::guildMemberUpdate);
        DispatchHandlers.addHandler(GuildRoleCreate.class, GuildDispatchHandlers::guildRoleCreate);
        DispatchHandlers.addHandler(GuildRoleDelete.class, GuildDispatchHandlers::guildRoleDelete);
        DispatchHandlers.addHandler(GuildRoleUpdate.class, GuildDispatchHandlers::guildRoleUpdate);
        DispatchHandlers.addHandler(GuildUpdate.class, GuildDispatchHandlers::guildUpdate);
        DispatchHandlers.addHandler(MessageCreate.class, MessageDispatchHandlers::messageCreate);
        DispatchHandlers.addHandler(MessageDelete.class, MessageDispatchHandlers::messageDelete);
        DispatchHandlers.addHandler(MessageDeleteBulk.class, MessageDispatchHandlers::messageDeleteBulk);
        DispatchHandlers.addHandler(MessageReactionAdd.class, MessageDispatchHandlers::messageReactionAdd);
        DispatchHandlers.addHandler(MessageReactionRemove.class, MessageDispatchHandlers::messageReactionRemove);
        DispatchHandlers.addHandler(MessageReactionRemoveEmoji.class, MessageDispatchHandlers::messageReactionRemoveEmoji);
        DispatchHandlers.addHandler(MessageReactionRemoveAll.class, MessageDispatchHandlers::messageReactionRemoveAll);
        DispatchHandlers.addHandler(MessageUpdate.class, MessageDispatchHandlers::messageUpdate);
        DispatchHandlers.addHandler(PresenceUpdate.class, DispatchHandlers::presenceUpdate);
        DispatchHandlers.addHandler(Ready.class, LifecycleDispatchHandlers::ready);
        DispatchHandlers.addHandler(Resumed.class, LifecycleDispatchHandlers::resumed);
        DispatchHandlers.addHandler(TypingStart.class, DispatchHandlers::typingStart);
        DispatchHandlers.addHandler(UserUpdate.class, DispatchHandlers::userUpdate);
        DispatchHandlers.addHandler(VoiceServerUpdate.class, DispatchHandlers::voiceServerUpdate);
        DispatchHandlers.addHandler(VoiceStateUpdateDispatch.class, DispatchHandlers::voiceStateUpdateDispatch);
        DispatchHandlers.addHandler(WebhooksUpdate.class, DispatchHandlers::webhooksUpdate);
        DispatchHandlers.addHandler(InviteCreate.class, DispatchHandlers::inviteCreate);
        DispatchHandlers.addHandler(InviteDelete.class, DispatchHandlers::inviteDelete);
        DispatchHandlers.addHandler(InteractionCreate.class, DispatchHandlers::interactionCreate);
        DispatchHandlers.addHandler(ApplicationCommandCreate.class, ApplicationCommandDispatchHandlers::applicationCommandCreate);
        DispatchHandlers.addHandler(ApplicationCommandUpdate.class, ApplicationCommandDispatchHandlers::applicationCommandUpdate);
        DispatchHandlers.addHandler(ApplicationCommandDelete.class, ApplicationCommandDispatchHandlers::applicationCommandDelete);
        DispatchHandlers.addHandler(IntegrationCreate.class, DispatchHandlers::integrationCreate);
        DispatchHandlers.addHandler(IntegrationUpdate.class, DispatchHandlers::integrationUpdate);
        DispatchHandlers.addHandler(IntegrationDelete.class, DispatchHandlers::integrationDelete);
        DispatchHandlers.addHandler(GatewayStateChange.class, LifecycleDispatchHandlers::gatewayStateChanged);
        DispatchHandlers.addHandler(UnavailableGuildCreate.class, context -> Mono.empty());
        log = Loggers.getLogger(DispatchHandlers.class);
    }
}

