/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ActivityUpdateRequest;
import discord4j.discordjson.json.gateway.StatusUpdate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="StatusUpdate", generator="Immutables")
public final class ImmutableStatusUpdate
implements StatusUpdate {
    private final Long since;
    private final ActivityUpdateRequest game;
    private final String status;
    private final boolean afk;

    private ImmutableStatusUpdate(Optional<Long> since, Optional<? extends ActivityUpdateRequest> game, String status, boolean afk) {
        this.since = since.orElse(null);
        this.game = game.orElse(null);
        this.status = Objects.requireNonNull(status, "status");
        this.afk = afk;
    }

    private ImmutableStatusUpdate(ImmutableStatusUpdate original, Long since, ActivityUpdateRequest game, String status, boolean afk) {
        this.since = since;
        this.game = game;
        this.status = status;
        this.afk = afk;
    }

    @Override
    @JsonProperty(value="since")
    public Optional<Long> since() {
        return Optional.ofNullable(this.since);
    }

    @Override
    @JsonProperty(value="game")
    public Optional<ActivityUpdateRequest> game() {
        return Optional.ofNullable(this.game);
    }

    @Override
    @JsonProperty(value="status")
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="afk")
    public boolean afk() {
        return this.afk;
    }

    public final ImmutableStatusUpdate withSince(long value) {
        Long newValue = value;
        if (Objects.equals(this.since, newValue)) {
            return this;
        }
        return new ImmutableStatusUpdate(this, newValue, this.game, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withSince(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.since, value)) {
            return this;
        }
        return new ImmutableStatusUpdate(this, value, this.game, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withGame(ActivityUpdateRequest value) {
        ActivityUpdateRequest newValue = Objects.requireNonNull(value, "game");
        if (this.game == newValue) {
            return this;
        }
        return new ImmutableStatusUpdate(this, this.since, newValue, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withGame(Optional<? extends ActivityUpdateRequest> optional) {
        ActivityUpdateRequest value = optional.orElse(null);
        if (this.game == value) {
            return this;
        }
        return new ImmutableStatusUpdate(this, this.since, value, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutableStatusUpdate(this, this.since, this.game, newValue, this.afk);
    }

    public final ImmutableStatusUpdate withAfk(boolean value) {
        if (this.afk == value) {
            return this;
        }
        return new ImmutableStatusUpdate(this, this.since, this.game, this.status, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatusUpdate && this.equalTo((ImmutableStatusUpdate)another);
    }

    private boolean equalTo(ImmutableStatusUpdate another) {
        return Objects.equals(this.since, another.since) && Objects.equals(this.game, another.game) && this.status.equals(another.status) && this.afk == another.afk;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.since);
        h += (h << 5) + Objects.hashCode(this.game);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Boolean.hashCode(this.afk);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StatusUpdate{");
        if (this.since != null) {
            builder.append("since=").append(this.since);
        }
        if (this.game != null) {
            if (builder.length() > 13) {
                builder.append(", ");
            }
            builder.append("game=").append(this.game);
        }
        if (builder.length() > 13) {
            builder.append(", ");
        }
        builder.append("status=").append(this.status);
        builder.append(", ");
        builder.append("afk=").append(this.afk);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatusUpdate fromJson(Json json) {
        Builder builder = ImmutableStatusUpdate.builder();
        if (json.since != null) {
            builder.since(json.since);
        }
        if (json.game != null) {
            builder.game(json.game);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.afkIsSet) {
            builder.afk(json.afk);
        }
        return builder.build();
    }

    public static ImmutableStatusUpdate of(Optional<Long> since, Optional<? extends ActivityUpdateRequest> game, String status, boolean afk) {
        return new ImmutableStatusUpdate(since, game, status, afk);
    }

    public static ImmutableStatusUpdate copyOf(StatusUpdate instance) {
        if (instance instanceof ImmutableStatusUpdate) {
            return (ImmutableStatusUpdate)instance;
        }
        return ImmutableStatusUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatusUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_AFK = 2L;
        private long initBits = 3L;
        private Long since;
        private ActivityUpdateRequest game;
        private String status;
        private boolean afk;

        private Builder() {
        }

        public final Builder from(StatusUpdate instance) {
            Optional<ActivityUpdateRequest> gameOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Long> sinceOptional = instance.since();
            if (sinceOptional.isPresent()) {
                this.since(sinceOptional);
            }
            if ((gameOptional = instance.game()).isPresent()) {
                this.game(gameOptional);
            }
            this.status(instance.status());
            this.afk(instance.afk());
            return this;
        }

        public final Builder since(long since) {
            this.since = since;
            return this;
        }

        @JsonProperty(value="since")
        public final Builder since(Optional<Long> since) {
            this.since = since.orElse(null);
            return this;
        }

        public final Builder game(ActivityUpdateRequest game) {
            this.game = Objects.requireNonNull(game, "game");
            return this;
        }

        @JsonProperty(value="game")
        public final Builder game(Optional<? extends ActivityUpdateRequest> game) {
            this.game = game.orElse(null);
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="afk")
        public final Builder afk(boolean afk) {
            this.afk = afk;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStatusUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatusUpdate(null, this.since, this.game, this.status, this.afk);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("afk");
            }
            return "Cannot build StatusUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StatusUpdate", generator="Immutables")
    static final class Json
    implements StatusUpdate {
        Optional<Long> since = Optional.empty();
        Optional<ActivityUpdateRequest> game = Optional.empty();
        String status;
        boolean afk;
        boolean afkIsSet;

        Json() {
        }

        @JsonProperty(value="since")
        public void setSince(Optional<Long> since) {
            this.since = since;
        }

        @JsonProperty(value="game")
        public void setGame(Optional<ActivityUpdateRequest> game) {
            this.game = game;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="afk")
        public void setAfk(boolean afk) {
            this.afk = afk;
            this.afkIsSet = true;
        }

        @Override
        public Optional<Long> since() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ActivityUpdateRequest> game() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean afk() {
            throw new UnsupportedOperationException();
        }
    }
}

