/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.config;

import com.gmail.berndivader.streamserver.StreamServer;
import com.gmail.berndivader.streamserver.config.ConfigData;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Scanner;

public class Config {
    public static String STREAM_KEY = "xxxx-xxxx-xxxx-xxxx-xxxx";
    public static String STREAM_URL = "rtmp://a.rtmp.youtube.com/live2";
    public static String YOUTUBE_LINK = "https://youtu.be/xxxxxxx";
    public static String YOUTUBE_KEY = "yt-api-key";
    public static Boolean STREAM_BOT_START = true;
    public static String PLAYLIST_PATH = "./playlist";
    public static String PLAYLIST_PATH_CUSTOM = "./custom";
    public static String DL_MUSIC_PATH = "./music";
    public static Long DL_TIMEOUT_SECONDS = 1800L;
    public static String DATABASE_CONNECTION = "jdbc:mysql://x.x.xxx.xxx:3306/ytbot";
    public static String DATABASE_USER = "default";
    public static String DATABASE_PWD = "default";
    public static String DISCORD_TOKEN = "default";
    public static String DISCORD_CHANNEL = "Mett TV";
    public static String DISCORD_ROLE = "Schef";
    public static String DISCORD_COMMAND_PREFIX = ".mtv";
    public static Boolean DISCORD_RESPONSE_TO_PRIVATE = true;
    public static Boolean DISCORD_BOT_START = true;
    public static String HELP_TEXT;
    public static String DISCORD_HELP_TEXT;
    public static File working_dir;
    public static File config_dir;
    public static File config_file;
    public static ConfigData data;
    public static Config instance;

    public Config() {
        instance = this;
        ConsoleRunner.print("Load or create config...");
        if (Config.loadConfig()) {
            ConsoleRunner.println("DONE!");
        } else {
            ConsoleRunner.println("FAILED!");
            ConsoleRunner.println("Using default values!");
        }
    }

    private static void createDefault() {
        config_dir.mkdir();
        data = new ConfigData();
        Config.saveConfig();
    }

    public static boolean saveConfig() {
        boolean ok = true;
        try (FileWriter writer = new FileWriter(config_file.getAbsoluteFile());){
            Config.data.PLAYLIST_PATH = PLAYLIST_PATH;
            Config.data.PLAYLIST_PATH_CUSTOM = PLAYLIST_PATH_CUSTOM;
            Config.data.DL_MUSIC_PATH = DL_MUSIC_PATH;
            Config.data.DL_TIMEOUT_SECONDS = DL_TIMEOUT_SECONDS;
            Config.data.STREAM_KEY = STREAM_KEY;
            Config.data.STREAM_URL = STREAM_URL;
            Config.data.YOUTUBE_LINK = YOUTUBE_LINK;
            Config.data.YOUTUBE_KEY = YOUTUBE_KEY;
            Config.data.STREAM_BOT_START = STREAM_BOT_START;
            Config.data.DATABASE_CONNECTION = DATABASE_CONNECTION;
            Config.data.DATABASE_USER = DATABASE_USER;
            Config.data.DATABASE_PWD = DATABASE_PWD;
            Config.data.DISCORD_TOKEN = DISCORD_TOKEN;
            Config.data.DISCORD_CHANNEL = DISCORD_CHANNEL;
            Config.data.DISCORD_ROLE = DISCORD_ROLE;
            Config.data.DISCORD_COMMAND_PREFIX = DISCORD_COMMAND_PREFIX;
            Config.data.DISCORD_RESPONSE_TO_PRIVATE = DISCORD_RESPONSE_TO_PRIVATE;
            Config.data.DISCORD_BOT_START = DISCORD_BOT_START;
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            ok = false;
            ConsoleRunner.println(e.getMessage());
        }
        return ok;
    }

    public static boolean loadConfig() {
        boolean ok = true;
        try (FileReader reader = new FileReader(config_file.getAbsoluteFile());){
            data = new Gson().fromJson((Reader)reader, ConfigData.class);
            if (Config.data.PLAYLIST_PATH != null) {
                PLAYLIST_PATH = Config.data.PLAYLIST_PATH;
            }
            if (Config.data.PLAYLIST_PATH_CUSTOM != null) {
                PLAYLIST_PATH_CUSTOM = Config.data.PLAYLIST_PATH_CUSTOM;
            }
            if (Config.data.DL_MUSIC_PATH != null) {
                DL_MUSIC_PATH = Config.data.DL_MUSIC_PATH;
            }
            if (Config.data.DL_TIMEOUT_SECONDS != null) {
                DL_TIMEOUT_SECONDS = Config.data.DL_TIMEOUT_SECONDS;
            }
            if (Config.data.STREAM_KEY != null) {
                STREAM_KEY = Config.data.STREAM_KEY;
            }
            if (Config.data.STREAM_URL != null) {
                STREAM_URL = Config.data.STREAM_URL;
            }
            if (Config.data.YOUTUBE_LINK != null) {
                YOUTUBE_LINK = Config.data.YOUTUBE_LINK;
            }
            if (Config.data.YOUTUBE_KEY != null) {
                YOUTUBE_KEY = Config.data.YOUTUBE_KEY;
            }
            if (Config.data.STREAM_BOT_START != null) {
                STREAM_BOT_START = Config.data.STREAM_BOT_START;
            }
            if (Config.data.DATABASE_CONNECTION != null) {
                DATABASE_CONNECTION = Config.data.DATABASE_CONNECTION;
            }
            if (Config.data.DATABASE_USER != null) {
                DATABASE_USER = Config.data.DATABASE_USER;
            }
            if (Config.data.DATABASE_PWD != null) {
                DATABASE_PWD = Config.data.DATABASE_PWD;
            }
            if (Config.data.DISCORD_TOKEN != null) {
                DISCORD_TOKEN = Config.data.DISCORD_TOKEN;
            }
            if (Config.data.DISCORD_CHANNEL != null) {
                DISCORD_CHANNEL = Config.data.DISCORD_CHANNEL;
            }
            if (Config.data.DISCORD_ROLE != null) {
                DISCORD_ROLE = Config.data.DISCORD_ROLE;
            }
            if (Config.data.DISCORD_COMMAND_PREFIX != null) {
                DISCORD_COMMAND_PREFIX = Config.data.DISCORD_COMMAND_PREFIX;
            }
            if (Config.data.DISCORD_RESPONSE_TO_PRIVATE != null) {
                DISCORD_RESPONSE_TO_PRIVATE = Config.data.DISCORD_RESPONSE_TO_PRIVATE;
            }
            if (Config.data.DISCORD_BOT_START != null) {
                DISCORD_BOT_START = Config.data.DISCORD_BOT_START;
            }
        }
        catch (IOException e) {
            ok = false;
            ConsoleRunner.println(e.getMessage());
        }
        if (!ok) {
            ConsoleRunner.println("Configuration couldnt be loaded.");
        }
        return ok;
    }

    static String inputstreamToString(InputStream is) {
        String output = null;
        try (Scanner s = new Scanner(is);){
            s.useDelimiter("\\A");
            output = s.hasNext() ? s.next() : "";
            try {
                is.close();
            }
            catch (IOException e1) {
                ConsoleRunner.println(e1.getMessage());
            }
        }
        return output;
    }

    static {
        try {
            HELP_TEXT = Config.inputstreamToString(StreamServer.class.getResourceAsStream("/help.txt"));
            DISCORD_HELP_TEXT = Config.inputstreamToString(StreamServer.class.getResourceAsStream("/discord_help.txt"));
            URI uri = StreamServer.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            working_dir = new File(uri.getPath().replace(new File(uri).getName(), ""));
        }
        catch (URISyntaxException ex) {
            ConsoleRunner.println(ex.getMessage());
        }
        config_dir = new File(working_dir.getAbsolutePath() + "/config");
        config_file = new File(config_dir.getAbsolutePath() + "/config.json");
        if (!config_dir.exists()) {
            config_dir.mkdir();
            Config.createDefault();
        }
        if (!config_file.exists()) {
            Config.createDefault();
        }
    }
}

