/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.InvalidationStrategy;
import discord4j.core.shard.KeyStoreRegistry;
import discord4j.core.shard.ShardAwareStoreService;
import discord4j.core.state.StateHolder;
import discord4j.gateway.ShardInfo;
import discord4j.store.api.service.StoreService;
import reactor.core.publisher.Mono;

class KeyStoreInvalidationStrategy
implements InvalidationStrategy {
    private final KeyStoreRegistry keyStoreRegistry;

    KeyStoreInvalidationStrategy(KeyStoreRegistry keyStoreRegistry) {
        this.keyStoreRegistry = keyStoreRegistry;
    }

    @Override
    public StoreService adaptStoreService(StoreService storeService) {
        return new ShardAwareStoreService(this.keyStoreRegistry, storeService);
    }

    @Override
    public Mono<Void> invalidate(ShardInfo shardInfo, StateHolder stateHolder) {
        return stateHolder.invalidateStores();
    }
}

