/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.github.kokorin.jaffree.ffmpeg.FFmpegProgress;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.util.concurrent.TimeUnit;

@ConsoleCommand(name="p", usage="[time|frames|bitrate|quality|fps|drops|size|speed] -> Show ffmpeg progress info.")
public class ProgressInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        if (BroadcastRunner.isStreaming()) {
            FFmpegProgress progress = BroadcastRunner.currentProgress;
            if (progress != null) {
                ANSI.println("===Progress information===");
                long duration = progress.getTime(TimeUnit.SECONDS);
                block23: for (int i1 = 0; i1 < args.length; ++i1) {
                    String option;
                    switch (option = args[i1]) {
                        case "time": {
                            ANSI.println("Playtime:" + duration / 60L + ":" + duration % 60L);
                            continue block23;
                        }
                        case "frames": 
                        case "frame": {
                            ANSI.println("Frames: " + progress.getFrame());
                            continue block23;
                        }
                        case "bitrate": 
                        case "bits": {
                            ANSI.println("Bitrate: " + progress.getBitrate());
                            continue block23;
                        }
                        case "quality": 
                        case "q": {
                            ANSI.println("Quality: " + progress.getQ());
                            continue block23;
                        }
                        case "fps": {
                            ANSI.println("FPS: " + progress.getFps());
                            continue block23;
                        }
                        case "drops": {
                            ANSI.println("Drops: " + progress.getDrop());
                            continue block23;
                        }
                        case "size": {
                            ANSI.println("Size: " + progress.getSize());
                            continue block23;
                        }
                        case "speed": {
                            ANSI.println("Speed: " + progress.getSpeed());
                            continue block23;
                        }
                        default: {
                            ANSI.println("Playtime:" + duration / 60L + ":" + duration % 60L);
                            ANSI.println("Frames: " + progress.getFrame());
                            ANSI.println("Bitrate: " + progress.getBitrate());
                            ANSI.println("Quality: " + progress.getQ());
                            ANSI.println("FPS: " + progress.getFps());
                            ANSI.println("Drops: " + progress.getDrop());
                            ANSI.println("Size: " + progress.getSize());
                            ANSI.println("Speed: " + progress.getSpeed());
                        }
                    }
                }
            } else {
                ANSI.println("No progress available atm.");
            }
        } else {
            ANSI.println("Currently no stream is running.");
        }
        return true;
    }
}

