/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.nico;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.nico.NicoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(NicoAudioTrack.class);
    private final NicoAudioSourceManager sourceManager;

    public NicoAudioTrack(AudioTrackInfo trackInfo, NicoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        this.sourceManager.checkLoggedIn();
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            this.loadVideoMainPage(httpInterface);
            String playbackUrl = this.loadPlaybackUrl(httpInterface);
            log.debug("Starting NicoNico track from URL: {}", (Object)playbackUrl);
            try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(playbackUrl), null);){
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void loadVideoMainPage(HttpInterface httpInterface) throws IOException {
        HttpGet request = new HttpGet("http://www.nicovideo.jp/watch/" + this.trackInfo.identifier);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Unexpected status code from video main page: " + statusCode);
            }
            EntityUtils.consume(response.getEntity());
        }
    }

    private String loadPlaybackUrl(HttpInterface httpInterface) throws IOException {
        HttpGet request = new HttpGet("http://flapi.nicovideo.jp/api/getflv/" + this.trackInfo.identifier);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Unexpected status code from playback parameters page: " + statusCode);
            }
            String text = EntityUtils.toString(response.getEntity());
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(text, StandardCharsets.UTF_8));
            String string = format.get("url");
            return string;
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new NicoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

