/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.BufferedReader;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

@ConsoleCommand(name="dl", usage="Download media. Usage: dl --url <http source> or use --help")
public class DownloadMedia
extends Command {
    @Override
    public boolean execute(String[] args) {
        File directory = new File(Config.DL_MUSIC_PATH);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (directory.isFile()) {
            return false;
        }
        Map.Entry<ProcessBuilder, Optional<InfoPacket>> entry = Helper.prepareDownloadBuilder(directory, args[0]);
        ProcessBuilder builder = entry.getKey();
        Optional<InfoPacket> infoPacket = entry.getValue();
        infoPacket.ifPresent(info -> ANSI.println(info.toString()));
        try {
            Process process = builder.start();
            Future<Boolean> future = Helper.EXECUTOR.submit(new InterruptHandler(process));
            BufferedReader input = process.inputReader();
            long time = System.currentTimeMillis();
            while (process.isAlive() && !future.isDone()) {
                if (input.ready()) {
                    String line2 = input.readLine();
                    if (line2.contains("[EmbedThumbnail]")) {
                        infoPacket.ifPresent(info -> {
                            String[] temp = line2.split("\"");
                            if (temp.length > 0) {
                                info.local_filename = temp[1];
                            }
                        });
                    }
                    time = System.currentTimeMillis();
                    ANSI.printRaw("[CR][DL]" + line2);
                    continue;
                }
                if (System.currentTimeMillis() - time <= Config.DL_TIMEOUT_SECONDS * 1000L) continue;
                ANSI.printRaw("[BR]");
                ANSI.printWarn("Download will be terminated, because it appears, that the process is stalled since " + Config.DL_TIMEOUT_SECONDS / 60L + " minutes.");
                process.destroy();
            }
            BufferedReader error = process.errorReader();
            if (error != null && error.ready()) {
                ANSI.printRaw("[BR]");
                error.lines().forEach(line -> ANSI.printWarn(line));
            }
            if (process.isAlive()) {
                process.destroy();
            }
        }
        catch (Exception e) {
            ANSI.printRaw("[BR]");
            ANSI.printErr("Error while looping yt-dlp process.", e);
        }
        return true;
    }

    private class InterruptHandler
    implements Callable<Boolean> {
        private final Process process;
        private boolean run = true;

        public InterruptHandler(Process process) {
            this.process = process;
        }

        @Override
        public Boolean call() throws Exception {
            while (this.run && this.process.isAlive()) {
                int avail = System.in.available();
                if (avail <= 0 || !Helper.getStringFromStream(System.in, avail).equals(".q")) continue;
                this.run = false;
            }
            if (this.process.isAlive()) {
                this.process.destroy();
            }
            return true;
        }
    }
}

