/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseConnection {
    public boolean INIT;
    public static DatabaseConnection instance;

    public DatabaseConnection() {
        Statement statement;
        Connection connection;
        instance = this;
        this.INIT = true;
        ANSI.print("Try connection to mysql database...");
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            ANSI.printErr("Missing jdbc driver.", e);
            this.INIT = false;
        }
        if (this.INIT) {
            try {
                connection = DatabaseConnection.getNewConnection();
                try {
                    statement = connection.prepareStatement("SELECT infotext FROM ytbot.info LIMIT 1", 1004, 1007);
                    try (ResultSet result = statement.executeQuery();){
                        if (result != null) {
                            result.first();
                            this.INIT = result.getString("infotext").equals("YouTube Broadcast Bot Database");
                            ANSI.println(this.INIT ? "DONE!" : "FAILED!");
                        } else {
                            ANSI.printWarn("Not able to identify the database!");
                            this.INIT = false;
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                ANSI.printErr("Creating mysql connection failed.", e);
                this.INIT = false;
            }
        }
        if (this.INIT) {
            try {
                connection = DatabaseConnection.getNewConnection();
                try {
                    statement = connection.createStatement(1004, 1007);
                    try {
                        statement.addBatch("START TRANSACTION;");
                        statement.addBatch("CREATE TABLE IF NOT EXISTS `downloadables` (`uuid` VARCHAR(36) NOT NULL, `path` VARCHAR(256) NOT NULL, `timestamp` INT NOT NULL, `downloads` INT NOT NULL);");
                        statement.addBatch("COMMIT;");
                        statement.executeBatch();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                ANSI.printErr("Failed to check for Downloadables table.", e);
            }
        }
    }

    public static Connection getNewConnection() throws SQLException {
        return DriverManager.getConnection(Config.DATABASE_CONNECTION, Config.DATABASE_USER, Config.DATABASE_PWD);
    }
}

