/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.RoleCreateSpec;
import discord4j.core.spec.Spec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildCreateRequest;
import discord4j.discordjson.json.ImmutableGuildCreateRequest;
import discord4j.discordjson.json.PartialChannelCreateRequest;
import discord4j.discordjson.json.RoleCreateRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public class GuildCreateSpec
implements Spec<GuildCreateRequest> {
    private final ImmutableGuildCreateRequest.Builder builder = GuildCreateRequest.builder();
    private final List<RoleCreateRequest> roles = new ArrayList<RoleCreateRequest>();

    public GuildCreateSpec setName(String name) {
        this.builder.name(name);
        return this;
    }

    public GuildCreateSpec setRegion(Region.Id regionId) {
        this.builder.region(regionId.getValue());
        return this;
    }

    public GuildCreateSpec setRegion(@Nullable String regionId) {
        this.builder.region(regionId == null ? Possible.absent() : Possible.of(regionId));
        return this;
    }

    public GuildCreateSpec setIcon(@Nullable Image icon) {
        this.builder.icon(icon == null ? Possible.absent() : Possible.of(icon.getDataUri()));
        return this;
    }

    public GuildCreateSpec setVerificationLevel(@Nullable Guild.VerificationLevel verificationLevel) {
        this.builder.verificationLevel(verificationLevel == null ? Possible.absent() : Possible.of(verificationLevel.getValue()));
        return this;
    }

    public GuildCreateSpec setDefaultMessageNotificationLevel(@Nullable Guild.NotificationLevel notificationLevel) {
        this.builder.defaultMessageNotifications(notificationLevel == null ? Possible.absent() : Possible.of(notificationLevel.getValue()));
        return this;
    }

    public GuildCreateSpec setExplicitContentFilter(@Nullable Guild.ContentFilterLevel explicitContentFilter) {
        this.builder.explicitContentFilter(explicitContentFilter == null ? Possible.absent() : Possible.of(explicitContentFilter.getValue()));
        return this;
    }

    public GuildCreateSpec addRole(Consumer<? super RoleCreateSpec> roleSpec) {
        RoleCreateSpec mutatedSpec = new RoleCreateSpec();
        roleSpec.accept(mutatedSpec);
        this.roles.add(mutatedSpec.asRequest());
        return this;
    }

    public GuildCreateSpec addEveryoneRole(Consumer<? super RoleCreateSpec> roleSpec) {
        RoleCreateSpec mutatedSpec = new RoleCreateSpec();
        roleSpec.accept(mutatedSpec);
        this.roles.add(0, mutatedSpec.asRequest());
        return this;
    }

    public GuildCreateSpec addChannel(String name, Channel.Type type) {
        this.builder.addChannel(PartialChannelCreateRequest.builder().name(name).type(type.getValue()).build());
        return this;
    }

    public GuildCreateSpec setAfkChannelId(@Nullable Snowflake id) {
        this.builder.afkChannelId(id == null ? Possible.absent() : Possible.of(Id.of(id.asLong())));
        return this;
    }

    public GuildCreateSpec setAfkTimeout(@Nullable Integer afkTimeout) {
        this.builder.afkTimeout(afkTimeout == null ? Possible.absent() : Possible.of(afkTimeout));
        return this;
    }

    public GuildCreateSpec setSystemChannelId(@Nullable Snowflake id) {
        this.builder.systemChannelId(id == null ? Possible.absent() : Possible.of(Id.of(id.asLong())));
        return this;
    }

    public GuildCreateSpec setSystemChannelFlags(Guild.SystemChannelFlag ... flags) {
        if (flags != null) {
            this.builder.systemChannelFlags(Possible.of(Arrays.stream(flags).mapToInt(Guild.SystemChannelFlag::getValue).reduce(0, (left, right) -> left | right)));
        } else {
            this.builder.systemChannelFlags(Possible.absent());
        }
        return this;
    }

    @Override
    public GuildCreateRequest asRequest() {
        this.builder.roles(this.roles);
        return this.builder.build();
    }
}

