/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.github.kokorin.jaffree.ffprobe.FFprobe;
import com.github.kokorin.jaffree.ffprobe.FFprobeResult;
import com.github.kokorin.jaffree.ffprobe.Format;
import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UpdatePlaylist
implements Callable<Boolean> {
    String sql = "INSERT INTO `playlist` (`title`, `filepath`, `info`) VALUES(?, ?, ?);";
    String[] spinner = new String[]{"\b/", "\b-", "\b\\", "\b|"};
    boolean isCommand;

    public UpdatePlaylist(boolean fromConsole) throws InterruptedException, ExecutionException, TimeoutException {
        Future<Boolean> future = Helper.EXECUTOR.submit(this);
        this.isCommand = fromConsole;
        if (this.isCommand) {
            if (future.get(20L, TimeUnit.MINUTES).booleanValue()) {
                ANSI.println("[BR][SUCSESSFUL MYSQL PLAYLIST UPDATE]");
            } else {
                ANSI.printWarn("[BR][FAILED MYSQL PLAYLIST UPDATE]");
            }
        }
    }

    static FFprobeResult getFFprobeResult(String path) {
        return FFprobe.atPath().setInput(path).setShowFormat(true).execute();
    }

    @Override
    public Boolean call() throws Exception {
        Helper.refreshFilelist();
        File[] files = (File[])Helper.files.clone();
        try (Connection connection = DatabaseConnection.getNewConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(this.sql, 1004, 1008);){
                ANSI.println("[BEGIN MYSQL PLAYLIST UPDATE]");
                if (this.isCommand) {
                    ANSI.print("|");
                }
                statement.addBatch("START TRANSACTION;");
                statement.addBatch("TRUNCATE TABLE playlist;");
                for (int i1 = 0; i1 < files.length; ++i1) {
                    Format format;
                    if (this.isCommand) {
                        ANSI.print(this.spinner[i1 % this.spinner.length]);
                    }
                    String path = files[i1].getAbsolutePath().replace("\\", "/");
                    String title = files[i1].getName();
                    Object comment = "null:null:null";
                    title = title.substring(0, title.length() - 4);
                    FFprobeResult result = UpdatePlaylist.getFFprobeResult(path);
                    if (result != null && (format = result.getFormat()) != null) {
                        comment = format.getTag("artist") + ":" + format.getTag("date") + ":" + format.getTag("comment");
                    }
                    statement.setString(1, title);
                    statement.setString(2, path);
                    statement.setString(3, (String)comment);
                    statement.addBatch();
                }
                statement.addBatch("COMMIT;");
                statement.executeBatch();
            }
            connection.commit();
        }
        catch (SQLException e) {
            ANSI.printErr("Update playlist failed.", e);
            return false;
        }
        return true;
    }
}

