/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.rest.util.PermissionSet;
import java.util.Optional;

public class PermissionOverwrite {
    private final long allowed;
    private final long denied;
    private final long targetId;
    private final Type type;

    public static PermissionOverwrite forMember(Snowflake memberId, PermissionSet allowed, PermissionSet denied) {
        return new PermissionOverwrite(allowed.getRawValue(), denied.getRawValue(), memberId.asLong(), Type.MEMBER);
    }

    public static PermissionOverwrite forRole(Snowflake roleId, PermissionSet allowed, PermissionSet denied) {
        return new PermissionOverwrite(allowed.getRawValue(), denied.getRawValue(), roleId.asLong(), Type.ROLE);
    }

    PermissionOverwrite(long allowed, long denied, long targetId, Type type) {
        this.allowed = allowed;
        this.denied = denied;
        this.targetId = targetId;
        this.type = type;
    }

    public PermissionSet getAllowed() {
        return PermissionSet.of(this.allowed);
    }

    public PermissionSet getDenied() {
        return PermissionSet.of(this.denied);
    }

    public Snowflake getTargetId() {
        return Snowflake.of(this.targetId);
    }

    public Optional<Snowflake> getRoleId() {
        return this.type == Type.ROLE ? Optional.of(this.getTargetId()) : Optional.empty();
    }

    public Optional<Snowflake> getMemberId() {
        return this.type == Type.MEMBER ? Optional.of(this.getTargetId()) : Optional.empty();
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "PermissionOverwrite{allowed=" + this.allowed + ", denied=" + this.denied + ", targetId=" + this.targetId + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        UNKNOWN("UNKNOWN"),
        ROLE("role"),
        MEMBER("member");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Type of(String value) {
            switch (value) {
                case "role": {
                    return ROLE;
                }
                case "member": {
                    return MEMBER;
                }
            }
            return UNKNOWN;
        }
    }
}

