/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import discord4j.discordjson.json.gateway.ApplicationCommandCreate;
import discord4j.discordjson.json.gateway.ApplicationCommandDelete;
import discord4j.discordjson.json.gateway.ApplicationCommandUpdate;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelPinsUpdate;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.Dispatch;
import discord4j.discordjson.json.gateway.GuildBanAdd;
import discord4j.discordjson.json.gateway.GuildBanRemove;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildIntegrationsUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.InteractionCreate;
import discord4j.discordjson.json.gateway.InviteCreate;
import discord4j.discordjson.json.gateway.InviteDelete;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.Opcode;
import discord4j.discordjson.json.gateway.PayloadData;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.Resumed;
import discord4j.discordjson.json.gateway.TypingStart;
import discord4j.discordjson.json.gateway.UnavailableGuildCreate;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceServerUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.discordjson.json.gateway.WebhooksUpdate;
import discord4j.gateway.json.GatewayPayload;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public class PayloadDeserializer
extends StdDeserializer<GatewayPayload<?>> {
    private static final String OP_FIELD = "op";
    private static final String D_FIELD = "d";
    private static final String T_FIELD = "t";
    private static final String S_FIELD = "s";
    private static final Map<String, Class<? extends Dispatch>> dispatchTypes = new HashMap<String, Class<? extends Dispatch>>();

    public PayloadDeserializer() {
        super(GatewayPayload.class);
    }

    @Override
    public GatewayPayload<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode d;
        JsonNode unavailable;
        JsonNode payload = (JsonNode)p.getCodec().readTree(p);
        int op = payload.get(OP_FIELD).asInt();
        String t = payload.get(T_FIELD).asText();
        Integer s = payload.get(S_FIELD).isNull() ? null : Integer.valueOf(payload.get(S_FIELD).intValue());
        Class<? extends PayloadData> payloadType = PayloadDeserializer.getPayloadType(op, t);
        if (payloadType == GuildCreate.class && (unavailable = (d = payload.get(D_FIELD)).get("unavailable")) != null && unavailable.asBoolean()) {
            PayloadData data = p.getCodec().treeToValue(d, UnavailableGuildCreate.class);
            return new GatewayPayload<PayloadData>(Opcode.forRaw(op), data, s, t);
        }
        PayloadData data = payloadType == null ? null : p.getCodec().treeToValue(payload.get(D_FIELD), payloadType);
        return new GatewayPayload<PayloadData>(Opcode.forRaw(op), data, s, t);
    }

    @Nullable
    private static Class<? extends PayloadData> getPayloadType(int op, String t) {
        if (op == Opcode.DISPATCH.getRawOp()) {
            if (!dispatchTypes.containsKey(t)) {
                throw new IllegalArgumentException("Attempt to deserialize payload with unknown event type: " + t);
            }
            return dispatchTypes.get(t);
        }
        Opcode<?> opcode = Opcode.forRaw(op);
        if (opcode == null) {
            throw new IllegalArgumentException("Attempt to deserialize payload with unknown op: " + op);
        }
        return opcode.getPayloadType();
    }

    static {
        dispatchTypes.put("READY", Ready.class);
        dispatchTypes.put("RESUMED", Resumed.class);
        dispatchTypes.put("CHANNEL_CREATE", ChannelCreate.class);
        dispatchTypes.put("CHANNEL_UPDATE", ChannelUpdate.class);
        dispatchTypes.put("CHANNEL_DELETE", ChannelDelete.class);
        dispatchTypes.put("CHANNEL_PINS_UPDATE", ChannelPinsUpdate.class);
        dispatchTypes.put("GUILD_CREATE", GuildCreate.class);
        dispatchTypes.put("GUILD_UPDATE", GuildUpdate.class);
        dispatchTypes.put("GUILD_DELETE", GuildDelete.class);
        dispatchTypes.put("GUILD_BAN_ADD", GuildBanAdd.class);
        dispatchTypes.put("GUILD_BAN_REMOVE", GuildBanRemove.class);
        dispatchTypes.put("GUILD_EMOJIS_UPDATE", GuildEmojisUpdate.class);
        dispatchTypes.put("GUILD_INTEGRATIONS_UPDATE", GuildIntegrationsUpdate.class);
        dispatchTypes.put("GUILD_MEMBER_ADD", GuildMemberAdd.class);
        dispatchTypes.put("GUILD_MEMBER_REMOVE", GuildMemberRemove.class);
        dispatchTypes.put("GUILD_MEMBER_UPDATE", GuildMemberUpdate.class);
        dispatchTypes.put("GUILD_MEMBERS_CHUNK", GuildMembersChunk.class);
        dispatchTypes.put("GUILD_ROLE_CREATE", GuildRoleCreate.class);
        dispatchTypes.put("GUILD_ROLE_UPDATE", GuildRoleUpdate.class);
        dispatchTypes.put("GUILD_ROLE_DELETE", GuildRoleDelete.class);
        dispatchTypes.put("MESSAGE_CREATE", MessageCreate.class);
        dispatchTypes.put("MESSAGE_UPDATE", MessageUpdate.class);
        dispatchTypes.put("MESSAGE_DELETE", MessageDelete.class);
        dispatchTypes.put("MESSAGE_DELETE_BULK", MessageDeleteBulk.class);
        dispatchTypes.put("MESSAGE_REACTION_ADD", MessageReactionAdd.class);
        dispatchTypes.put("MESSAGE_REACTION_REMOVE", MessageReactionRemove.class);
        dispatchTypes.put("MESSAGE_REACTION_REMOVE_ALL", MessageReactionRemoveAll.class);
        dispatchTypes.put("MESSAGE_REACTION_REMOVE_EMOJI", MessageReactionRemoveEmoji.class);
        dispatchTypes.put("PRESENCE_UPDATE", PresenceUpdate.class);
        dispatchTypes.put("TYPING_START", TypingStart.class);
        dispatchTypes.put("USER_UPDATE", UserUpdate.class);
        dispatchTypes.put("VOICE_STATE_UPDATE", VoiceStateUpdateDispatch.class);
        dispatchTypes.put("VOICE_SERVER_UPDATE", VoiceServerUpdate.class);
        dispatchTypes.put("WEBHOOKS_UPDATE", WebhooksUpdate.class);
        dispatchTypes.put("INVITE_CREATE", InviteCreate.class);
        dispatchTypes.put("INVITE_DELETE", InviteDelete.class);
        dispatchTypes.put("APPLICATION_COMMAND_CREATE", ApplicationCommandCreate.class);
        dispatchTypes.put("APPLICATION_COMMAND_UPDATE", ApplicationCommandUpdate.class);
        dispatchTypes.put("APPLICATION_COMMAND_DELETE", ApplicationCommandDelete.class);
        dispatchTypes.put("INTERACTION_CREATE", InteractionCreate.class);
        dispatchTypes.put("PRESENCES_REPLACE", null);
        dispatchTypes.put("GIFT_CODE_UPDATE", null);
        dispatchTypes.put("INTEGRATION_CREATE", null);
        dispatchTypes.put("INTEGRATION_UPDATE", null);
        dispatchTypes.put("INTEGRATION_DELETE", null);
    }
}

